package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class UpdateRecommenderRequest(
    recommenderArn: Arn,
    recommenderConfig: zio.aws.personalize.model.RecommenderConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.UpdateRecommenderRequest = {
    import UpdateRecommenderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.UpdateRecommenderRequest
      .builder()
      .recommenderArn(Arn.unwrap(recommenderArn): java.lang.String)
      .recommenderConfig(recommenderConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.UpdateRecommenderRequest.ReadOnly =
    zio.aws.personalize.model.UpdateRecommenderRequest.wrap(buildAwsValue())
}
object UpdateRecommenderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.UpdateRecommenderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.UpdateRecommenderRequest =
      zio.aws.personalize.model
        .UpdateRecommenderRequest(recommenderArn, recommenderConfig.asEditable)
    def recommenderArn: Arn
    def recommenderConfig: zio.aws.personalize.model.RecommenderConfig.ReadOnly
    def getRecommenderArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(recommenderArn)
    def getRecommenderConfig: ZIO[
      Any,
      Nothing,
      zio.aws.personalize.model.RecommenderConfig.ReadOnly
    ] = ZIO.succeed(recommenderConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.UpdateRecommenderRequest
  ) extends zio.aws.personalize.model.UpdateRecommenderRequest.ReadOnly {
    override val recommenderArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.recommenderArn())
    override val recommenderConfig
        : zio.aws.personalize.model.RecommenderConfig.ReadOnly =
      zio.aws.personalize.model.RecommenderConfig.wrap(impl.recommenderConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.UpdateRecommenderRequest
  ): zio.aws.personalize.model.UpdateRecommenderRequest.ReadOnly = new Wrapper(
    impl
  )
}
