package zio.aws.personalize
import zio.prelude.Subtype
import zio.aws.personalize.model.primitives.{
  MetricName,
  CategoricalValue,
  ParameterName,
  ParameterValue,
  Arn,
  MetricValue
}
import java.time.Instant
import zio.aws.personalize.model.primitives.ContinuousMaxValue.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.personalize.model.primitives.AccountId.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.personalize.model.primitives.Arn.Type
    object AvroSchema extends Subtype[String]
    type AvroSchema = zio.aws.personalize.model.primitives.AvroSchema.Type
    object CategoricalValue extends Subtype[String]
    type CategoricalValue =
      zio.aws.personalize.model.primitives.CategoricalValue.Type
    object ContinuousMaxValue extends Subtype[Double]
    type ContinuousMaxValue =
      zio.aws.personalize.model.primitives.ContinuousMaxValue.Type
    object ContinuousMinValue extends Subtype[Double]
    type ContinuousMinValue =
      zio.aws.personalize.model.primitives.ContinuousMinValue.Type
    object DatasetType extends Subtype[String]
    type DatasetType = zio.aws.personalize.model.primitives.DatasetType.Type
    object Date extends Subtype[Instant]
    type Date = zio.aws.personalize.model.primitives.Date.Type
    object Description extends Subtype[String]
    type Description = zio.aws.personalize.model.primitives.Description.Type
    object DockerURI extends Subtype[String]
    type DockerURI = zio.aws.personalize.model.primitives.DockerURI.Type
    object EventType extends Subtype[String]
    type EventType = zio.aws.personalize.model.primitives.EventType.Type
    object EventValueThreshold extends Subtype[String]
    type EventValueThreshold =
      zio.aws.personalize.model.primitives.EventValueThreshold.Type
    object FailureReason extends Subtype[String]
    type FailureReason = zio.aws.personalize.model.primitives.FailureReason.Type
    object FilterExpression extends Subtype[String]
    type FilterExpression =
      zio.aws.personalize.model.primitives.FilterExpression.Type
    object HPOObjectiveType extends Subtype[String]
    type HPOObjectiveType =
      zio.aws.personalize.model.primitives.HPOObjectiveType.Type
    object HPOResource extends Subtype[String]
    type HPOResource = zio.aws.personalize.model.primitives.HPOResource.Type
    object IntegerMaxValue extends Subtype[Int]
    type IntegerMaxValue =
      zio.aws.personalize.model.primitives.IntegerMaxValue.Type
    object IntegerMinValue extends Subtype[Int]
    type IntegerMinValue =
      zio.aws.personalize.model.primitives.IntegerMinValue.Type
    object ItemAttribute extends Subtype[String]
    type ItemAttribute = zio.aws.personalize.model.primitives.ItemAttribute.Type
    object KmsKeyArn extends Subtype[String]
    type KmsKeyArn = zio.aws.personalize.model.primitives.KmsKeyArn.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.personalize.model.primitives.MaxResults.Type
    object MetricName extends Subtype[String]
    type MetricName = zio.aws.personalize.model.primitives.MetricName.Type
    object MetricRegex extends Subtype[String]
    type MetricRegex = zio.aws.personalize.model.primitives.MetricRegex.Type
    object MetricValue extends Subtype[Double]
    type MetricValue = zio.aws.personalize.model.primitives.MetricValue.Type
    object Name extends Subtype[String]
    type Name = zio.aws.personalize.model.primitives.Name.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.personalize.model.primitives.NextToken.Type
    object NumBatchResults extends Subtype[Int]
    type NumBatchResults =
      zio.aws.personalize.model.primitives.NumBatchResults.Type
    object ParameterName extends Subtype[String]
    type ParameterName = zio.aws.personalize.model.primitives.ParameterName.Type
    object ParameterValue extends Subtype[String]
    type ParameterValue =
      zio.aws.personalize.model.primitives.ParameterValue.Type
    object PerformAutoML extends Subtype[Boolean]
    type PerformAutoML = zio.aws.personalize.model.primitives.PerformAutoML.Type
    object PerformHPO extends Subtype[Boolean]
    type PerformHPO = zio.aws.personalize.model.primitives.PerformHPO.Type
    object RecipeType extends Subtype[String]
    type RecipeType = zio.aws.personalize.model.primitives.RecipeType.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.personalize.model.primitives.RoleArn.Type
    object S3Location extends Subtype[String]
    type S3Location = zio.aws.personalize.model.primitives.S3Location.Type
    object Status extends Subtype[String]
    type Status = zio.aws.personalize.model.primitives.Status.Type
    object TrackingId extends Subtype[String]
    type TrackingId = zio.aws.personalize.model.primitives.TrackingId.Type
    object TrainingHours extends Subtype[Double]
    type TrainingHours = zio.aws.personalize.model.primitives.TrainingHours.Type
    object TrainingInputMode extends Subtype[String]
    type TrainingInputMode =
      zio.aws.personalize.model.primitives.TrainingInputMode.Type
    object TransactionsPerSecond extends Subtype[Int]
    type TransactionsPerSecond =
      zio.aws.personalize.model.primitives.TransactionsPerSecond.Type
    object Tunable extends Subtype[Boolean]
    type Tunable = zio.aws.personalize.model.primitives.Tunable.Type
  }
  type ArnList = List[Arn]
  type BatchInferenceJobs =
    List[zio.aws.personalize.model.BatchInferenceJobSummary]
  type BatchSegmentJobs = List[zio.aws.personalize.model.BatchSegmentJobSummary]
  type Campaigns = List[zio.aws.personalize.model.CampaignSummary]
  type CategoricalHyperParameterRanges =
    List[zio.aws.personalize.model.CategoricalHyperParameterRange]
  type CategoricalValues = List[CategoricalValue]
  type ContinuousHyperParameterRanges =
    List[zio.aws.personalize.model.ContinuousHyperParameterRange]
  type DatasetExportJobs =
    List[zio.aws.personalize.model.DatasetExportJobSummary]
  type DatasetGroups = List[zio.aws.personalize.model.DatasetGroupSummary]
  type DatasetImportJobs =
    List[zio.aws.personalize.model.DatasetImportJobSummary]
  type Datasets = List[zio.aws.personalize.model.DatasetSummary]
  type DefaultCategoricalHyperParameterRanges =
    List[zio.aws.personalize.model.DefaultCategoricalHyperParameterRange]
  type DefaultContinuousHyperParameterRanges =
    List[zio.aws.personalize.model.DefaultContinuousHyperParameterRange]
  type DefaultIntegerHyperParameterRanges =
    List[zio.aws.personalize.model.DefaultIntegerHyperParameterRange]
  type EventTrackers = List[zio.aws.personalize.model.EventTrackerSummary]
  type FeatureTransformationParameters = Map[ParameterName, ParameterValue]
  type FeaturizationParameters = Map[ParameterName, ParameterValue]
  type Filters = List[zio.aws.personalize.model.FilterSummary]
  type HyperParameters = Map[ParameterName, ParameterValue]
  type IntegerHyperParameterRanges =
    List[zio.aws.personalize.model.IntegerHyperParameterRange]
  type Metrics = Map[MetricName, MetricValue]
  type Recipes = List[zio.aws.personalize.model.RecipeSummary]
  type Recommenders = List[zio.aws.personalize.model.RecommenderSummary]
  type ResourceConfig = Map[ParameterName, ParameterValue]
  type Schemas = List[zio.aws.personalize.model.DatasetSchemaSummary]
  type SolutionVersions = List[zio.aws.personalize.model.SolutionVersionSummary]
  type Solutions = List[zio.aws.personalize.model.SolutionSummary]
}
