package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{CategoricalValue, ParameterName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CategoricalHyperParameterRange(
    name: Optional[ParameterName] = Optional.Absent,
    values: Optional[Iterable[CategoricalValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CategoricalHyperParameterRange = {
    import CategoricalHyperParameterRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CategoricalHyperParameterRange
      .builder()
      .optionallyWith(
        name.map(value => ParameterName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            CategoricalValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CategoricalHyperParameterRange.ReadOnly =
    zio.aws.personalize.model.CategoricalHyperParameterRange
      .wrap(buildAwsValue())
}
object CategoricalHyperParameterRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CategoricalHyperParameterRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CategoricalHyperParameterRange =
      zio.aws.personalize.model.CategoricalHyperParameterRange(
        name.map(value => value),
        values.map(value => value)
      )
    def name: Optional[ParameterName]
    def values: Optional[List[CategoricalValue]]
    def getName: ZIO[Any, AwsError, ParameterName] =
      AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[CategoricalValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CategoricalHyperParameterRange
  ) extends zio.aws.personalize.model.CategoricalHyperParameterRange.ReadOnly {
    override val name: Optional[ParameterName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.ParameterName(value))
    override val values: Optional[List[CategoricalValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.primitives.CategoricalValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CategoricalHyperParameterRange
  ): zio.aws.personalize.model.CategoricalHyperParameterRange.ReadOnly =
    new Wrapper(impl)
}
