package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{RoleArn, Arn, Name}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDatasetExportJobRequest(
    jobName: Name,
    datasetArn: Arn,
    ingestionMode: Optional[zio.aws.personalize.model.IngestionMode] =
      Optional.Absent,
    roleArn: RoleArn,
    jobOutput: zio.aws.personalize.model.DatasetExportJobOutput,
    tags: Optional[Iterable[zio.aws.personalize.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobRequest = {
    import CreateDatasetExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobRequest
      .builder()
      .jobName(Name.unwrap(jobName): java.lang.String)
      .datasetArn(Arn.unwrap(datasetArn): java.lang.String)
      .optionallyWith(ingestionMode.map(value => value.unwrap))(_.ingestionMode)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .jobOutput(jobOutput.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateDatasetExportJobRequest.ReadOnly =
    zio.aws.personalize.model.CreateDatasetExportJobRequest
      .wrap(buildAwsValue())
}
object CreateDatasetExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateDatasetExportJobRequest =
      zio.aws.personalize.model.CreateDatasetExportJobRequest(
        jobName,
        datasetArn,
        ingestionMode.map(value => value),
        roleArn,
        jobOutput.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobName: Name
    def datasetArn: Arn
    def ingestionMode: Optional[zio.aws.personalize.model.IngestionMode]
    def roleArn: RoleArn
    def jobOutput: zio.aws.personalize.model.DatasetExportJobOutput.ReadOnly
    def tags: Optional[List[zio.aws.personalize.model.Tag.ReadOnly]]
    def getJobName: ZIO[Any, Nothing, Name] = ZIO.succeed(jobName)
    def getDatasetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(datasetArn)
    def getIngestionMode
        : ZIO[Any, AwsError, zio.aws.personalize.model.IngestionMode] =
      AwsError.unwrapOptionField("ingestionMode", ingestionMode)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getJobOutput: ZIO[
      Any,
      Nothing,
      zio.aws.personalize.model.DatasetExportJobOutput.ReadOnly
    ] = ZIO.succeed(jobOutput)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.personalize.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobRequest
  ) extends zio.aws.personalize.model.CreateDatasetExportJobRequest.ReadOnly {
    override val jobName: Name =
      zio.aws.personalize.model.primitives.Name(impl.jobName())
    override val datasetArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetArn())
    override val ingestionMode
        : Optional[zio.aws.personalize.model.IngestionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ingestionMode())
        .map(value => zio.aws.personalize.model.IngestionMode.wrap(value))
    override val roleArn: RoleArn =
      zio.aws.personalize.model.primitives.RoleArn(impl.roleArn())
    override val jobOutput
        : zio.aws.personalize.model.DatasetExportJobOutput.ReadOnly =
      zio.aws.personalize.model.DatasetExportJobOutput.wrap(impl.jobOutput())
    override val tags: Optional[List[zio.aws.personalize.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobRequest
  ): zio.aws.personalize.model.CreateDatasetExportJobRequest.ReadOnly =
    new Wrapper(impl)
}
