package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{KmsKeyArn, RoleArn, Name}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDatasetGroupRequest(
    name: Name,
    roleArn: Optional[RoleArn] = Optional.Absent,
    kmsKeyArn: Optional[KmsKeyArn] = Optional.Absent,
    domain: Optional[zio.aws.personalize.model.Domain] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.personalize.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateDatasetGroupRequest = {
    import CreateDatasetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateDatasetGroupRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CreateDatasetGroupRequest.ReadOnly =
    zio.aws.personalize.model.CreateDatasetGroupRequest.wrap(buildAwsValue())
}
object CreateDatasetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateDatasetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateDatasetGroupRequest =
      zio.aws.personalize.model.CreateDatasetGroupRequest(
        name,
        roleArn.map(value => value),
        kmsKeyArn.map(value => value),
        domain.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Name
    def roleArn: Optional[RoleArn]
    def kmsKeyArn: Optional[KmsKeyArn]
    def domain: Optional[zio.aws.personalize.model.Domain]
    def tags: Optional[List[zio.aws.personalize.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getDomain: ZIO[Any, AwsError, zio.aws.personalize.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.personalize.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetGroupRequest
  ) extends zio.aws.personalize.model.CreateDatasetGroupRequest.ReadOnly {
    override val name: Name =
      zio.aws.personalize.model.primitives.Name(impl.name())
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.personalize.model.primitives.RoleArn(value))
    override val kmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.personalize.model.primitives.KmsKeyArn(value))
    override val domain: Optional[zio.aws.personalize.model.Domain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domain())
        .map(value => zio.aws.personalize.model.Domain.wrap(value))
    override val tags: Optional[List[zio.aws.personalize.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetGroupRequest
  ): zio.aws.personalize.model.CreateDatasetGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
