package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{Arn, Name}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateRecommenderRequest(
    name: Name,
    datasetGroupArn: Arn,
    recipeArn: Arn,
    recommenderConfig: Optional[zio.aws.personalize.model.RecommenderConfig] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.personalize.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateRecommenderRequest = {
    import CreateRecommenderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateRecommenderRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .datasetGroupArn(Arn.unwrap(datasetGroupArn): java.lang.String)
      .recipeArn(Arn.unwrap(recipeArn): java.lang.String)
      .optionallyWith(recommenderConfig.map(value => value.buildAwsValue()))(
        _.recommenderConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CreateRecommenderRequest.ReadOnly =
    zio.aws.personalize.model.CreateRecommenderRequest.wrap(buildAwsValue())
}
object CreateRecommenderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateRecommenderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateRecommenderRequest =
      zio.aws.personalize.model.CreateRecommenderRequest(
        name,
        datasetGroupArn,
        recipeArn,
        recommenderConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Name
    def datasetGroupArn: Arn
    def recipeArn: Arn
    def recommenderConfig
        : Optional[zio.aws.personalize.model.RecommenderConfig.ReadOnly]
    def tags: Optional[List[zio.aws.personalize.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDatasetGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetGroupArn)
    def getRecipeArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(recipeArn)
    def getRecommenderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.RecommenderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("recommenderConfig", recommenderConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.personalize.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateRecommenderRequest
  ) extends zio.aws.personalize.model.CreateRecommenderRequest.ReadOnly {
    override val name: Name =
      zio.aws.personalize.model.primitives.Name(impl.name())
    override val datasetGroupArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetGroupArn())
    override val recipeArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.recipeArn())
    override val recommenderConfig
        : Optional[zio.aws.personalize.model.RecommenderConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommenderConfig())
        .map(value => zio.aws.personalize.model.RecommenderConfig.wrap(value))
    override val tags: Optional[List[zio.aws.personalize.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateRecommenderRequest
  ): zio.aws.personalize.model.CreateRecommenderRequest.ReadOnly = new Wrapper(
    impl
  )
}
