package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  EventType,
  Arn,
  PerformAutoML,
  Name
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSolutionRequest(
    name: Name,
    performHPO: Optional[Boolean] = Optional.Absent,
    performAutoML: Optional[PerformAutoML] = Optional.Absent,
    recipeArn: Optional[Arn] = Optional.Absent,
    datasetGroupArn: Arn,
    eventType: Optional[EventType] = Optional.Absent,
    solutionConfig: Optional[zio.aws.personalize.model.SolutionConfig] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.personalize.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateSolutionRequest = {
    import CreateSolutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateSolutionRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(performHPO.map(value => value: java.lang.Boolean))(
        _.performHPO
      )
      .optionallyWith(
        performAutoML.map(value =>
          PerformAutoML.unwrap(value): java.lang.Boolean
        )
      )(_.performAutoML)
      .optionallyWith(
        recipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recipeArn)
      .datasetGroupArn(Arn.unwrap(datasetGroupArn): java.lang.String)
      .optionallyWith(
        eventType.map(value => EventType.unwrap(value): java.lang.String)
      )(_.eventType)
      .optionallyWith(solutionConfig.map(value => value.buildAwsValue()))(
        _.solutionConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CreateSolutionRequest.ReadOnly =
    zio.aws.personalize.model.CreateSolutionRequest.wrap(buildAwsValue())
}
object CreateSolutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateSolutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateSolutionRequest =
      zio.aws.personalize.model.CreateSolutionRequest(
        name,
        performHPO.map(value => value),
        performAutoML.map(value => value),
        recipeArn.map(value => value),
        datasetGroupArn,
        eventType.map(value => value),
        solutionConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Name
    def performHPO: Optional[Boolean]
    def performAutoML: Optional[PerformAutoML]
    def recipeArn: Optional[Arn]
    def datasetGroupArn: Arn
    def eventType: Optional[EventType]
    def solutionConfig
        : Optional[zio.aws.personalize.model.SolutionConfig.ReadOnly]
    def tags: Optional[List[zio.aws.personalize.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getPerformHPO: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("performHPO", performHPO)
    def getPerformAutoML: ZIO[Any, AwsError, PerformAutoML] =
      AwsError.unwrapOptionField("performAutoML", performAutoML)
    def getRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recipeArn", recipeArn)
    def getDatasetGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetGroupArn)
    def getEventType: ZIO[Any, AwsError, EventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getSolutionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.SolutionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("solutionConfig", solutionConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.personalize.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateSolutionRequest
  ) extends zio.aws.personalize.model.CreateSolutionRequest.ReadOnly {
    override val name: Name =
      zio.aws.personalize.model.primitives.Name(impl.name())
    override val performHPO: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.performHPO())
      .map(value => value: Boolean)
    override val performAutoML: Optional[PerformAutoML] = zio.aws.core.internal
      .optionalFromNullable(impl.performAutoML())
      .map(value => zio.aws.personalize.model.primitives.PerformAutoML(value))
    override val recipeArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.recipeArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val datasetGroupArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetGroupArn())
    override val eventType: Optional[EventType] = zio.aws.core.internal
      .optionalFromNullable(impl.eventType())
      .map(value => zio.aws.personalize.model.primitives.EventType(value))
    override val solutionConfig
        : Optional[zio.aws.personalize.model.SolutionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solutionConfig())
        .map(value => zio.aws.personalize.model.SolutionConfig.wrap(value))
    override val tags: Optional[List[zio.aws.personalize.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateSolutionRequest
  ): zio.aws.personalize.model.CreateSolutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
