package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.S3Location
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataSource(
    dataLocation: Optional[S3Location] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DataSource = {
    import DataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DataSource
      .builder()
      .optionallyWith(
        dataLocation.map(value => S3Location.unwrap(value): java.lang.String)
      )(_.dataLocation)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DataSource.ReadOnly =
    zio.aws.personalize.model.DataSource.wrap(buildAwsValue())
}
object DataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DataSource =
      zio.aws.personalize.model.DataSource(dataLocation.map(value => value))
    def dataLocation: Optional[S3Location]
    def getDataLocation: ZIO[Any, AwsError, S3Location] =
      AwsError.unwrapOptionField("dataLocation", dataLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DataSource
  ) extends zio.aws.personalize.model.DataSource.ReadOnly {
    override val dataLocation: Optional[S3Location] = zio.aws.core.internal
      .optionalFromNullable(impl.dataLocation())
      .map(value => zio.aws.personalize.model.primitives.S3Location(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DataSource
  ): zio.aws.personalize.model.DataSource.ReadOnly = new Wrapper(impl)
}
