package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  Tunable,
  CategoricalValue,
  ParameterName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DefaultCategoricalHyperParameterRange(
    name: Optional[ParameterName] = Optional.Absent,
    values: Optional[Iterable[CategoricalValue]] = Optional.Absent,
    isTunable: Optional[Tunable] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DefaultCategoricalHyperParameterRange = {
    import DefaultCategoricalHyperParameterRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DefaultCategoricalHyperParameterRange
      .builder()
      .optionallyWith(
        name.map(value => ParameterName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            CategoricalValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .optionallyWith(
        isTunable.map(value => Tunable.unwrap(value): java.lang.Boolean)
      )(_.isTunable)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DefaultCategoricalHyperParameterRange.ReadOnly =
    zio.aws.personalize.model.DefaultCategoricalHyperParameterRange
      .wrap(buildAwsValue())
}
object DefaultCategoricalHyperParameterRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DefaultCategoricalHyperParameterRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.personalize.model.DefaultCategoricalHyperParameterRange =
      zio.aws.personalize.model.DefaultCategoricalHyperParameterRange(
        name.map(value => value),
        values.map(value => value),
        isTunable.map(value => value)
      )
    def name: Optional[ParameterName]
    def values: Optional[List[CategoricalValue]]
    def isTunable: Optional[Tunable]
    def getName: ZIO[Any, AwsError, ParameterName] =
      AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[CategoricalValue]] =
      AwsError.unwrapOptionField("values", values)
    def getIsTunable: ZIO[Any, AwsError, Tunable] =
      AwsError.unwrapOptionField("isTunable", isTunable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DefaultCategoricalHyperParameterRange
  ) extends zio.aws.personalize.model.DefaultCategoricalHyperParameterRange.ReadOnly {
    override val name: Optional[ParameterName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.ParameterName(value))
    override val values: Optional[List[CategoricalValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.primitives.CategoricalValue(item)
          }.toList
        )
    override val isTunable: Optional[Tunable] = zio.aws.core.internal
      .optionalFromNullable(impl.isTunable())
      .map(value => zio.aws.personalize.model.primitives.Tunable(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DefaultCategoricalHyperParameterRange
  ): zio.aws.personalize.model.DefaultCategoricalHyperParameterRange.ReadOnly =
    new Wrapper(impl)
}
