package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeAlgorithmRequest(algorithmArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeAlgorithmRequest = {
    import DescribeAlgorithmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeAlgorithmRequest
      .builder()
      .algorithmArn(Arn.unwrap(algorithmArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DescribeAlgorithmRequest.ReadOnly =
    zio.aws.personalize.model.DescribeAlgorithmRequest.wrap(buildAwsValue())
}
object DescribeAlgorithmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeAlgorithmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeAlgorithmRequest =
      zio.aws.personalize.model.DescribeAlgorithmRequest(algorithmArn)
    def algorithmArn: Arn
    def getAlgorithmArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(algorithmArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeAlgorithmRequest
  ) extends zio.aws.personalize.model.DescribeAlgorithmRequest.ReadOnly {
    override val algorithmArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.algorithmArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeAlgorithmRequest
  ): zio.aws.personalize.model.DescribeAlgorithmRequest.ReadOnly = new Wrapper(
    impl
  )
}
