package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeDatasetExportJobRequest(datasetExportJobArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeDatasetExportJobRequest = {
    import DescribeDatasetExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeDatasetExportJobRequest
      .builder()
      .datasetExportJobArn(Arn.unwrap(datasetExportJobArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeDatasetExportJobRequest.ReadOnly =
    zio.aws.personalize.model.DescribeDatasetExportJobRequest
      .wrap(buildAwsValue())
}
object DescribeDatasetExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeDatasetExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeDatasetExportJobRequest =
      zio.aws.personalize.model
        .DescribeDatasetExportJobRequest(datasetExportJobArn)
    def datasetExportJobArn: Arn
    def getDatasetExportJobArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetExportJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeDatasetExportJobRequest
  ) extends zio.aws.personalize.model.DescribeDatasetExportJobRequest.ReadOnly {
    override val datasetExportJobArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetExportJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeDatasetExportJobRequest
  ): zio.aws.personalize.model.DescribeDatasetExportJobRequest.ReadOnly =
    new Wrapper(impl)
}
