package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeDatasetRequest(datasetArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeDatasetRequest = {
    import DescribeDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeDatasetRequest
      .builder()
      .datasetArn(Arn.unwrap(datasetArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DescribeDatasetRequest.ReadOnly =
    zio.aws.personalize.model.DescribeDatasetRequest.wrap(buildAwsValue())
}
object DescribeDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeDatasetRequest =
      zio.aws.personalize.model.DescribeDatasetRequest(datasetArn)
    def datasetArn: Arn
    def getDatasetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(datasetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeDatasetRequest
  ) extends zio.aws.personalize.model.DescribeDatasetRequest.ReadOnly {
    override val datasetArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeDatasetRequest
  ): zio.aws.personalize.model.DescribeDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
