package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  Status,
  TrackingId,
  Date,
  AccountId,
  Arn,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EventTracker(
    name: Optional[Name] = Optional.Absent,
    eventTrackerArn: Optional[Arn] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent,
    trackingId: Optional[TrackingId] = Optional.Absent,
    datasetGroupArn: Optional[Arn] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.EventTracker = {
    import EventTracker.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.EventTracker
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        eventTrackerArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventTrackerArn)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        trackingId.map(value => TrackingId.unwrap(value): java.lang.String)
      )(_.trackingId)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.EventTracker.ReadOnly =
    zio.aws.personalize.model.EventTracker.wrap(buildAwsValue())
}
object EventTracker {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.EventTracker
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.EventTracker =
      zio.aws.personalize.model.EventTracker(
        name.map(value => value),
        eventTrackerArn.map(value => value),
        accountId.map(value => value),
        trackingId.map(value => value),
        datasetGroupArn.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def name: Optional[Name]
    def eventTrackerArn: Optional[Arn]
    def accountId: Optional[AccountId]
    def trackingId: Optional[TrackingId]
    def datasetGroupArn: Optional[Arn]
    def status: Optional[Status]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getEventTrackerArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventTrackerArn", eventTrackerArn)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getTrackingId: ZIO[Any, AwsError, TrackingId] =
      AwsError.unwrapOptionField("trackingId", trackingId)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.EventTracker
  ) extends zio.aws.personalize.model.EventTracker.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val eventTrackerArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.eventTrackerArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.personalize.model.primitives.AccountId(value))
    override val trackingId: Optional[TrackingId] = zio.aws.core.internal
      .optionalFromNullable(impl.trackingId())
      .map(value => zio.aws.personalize.model.primitives.TrackingId(value))
    override val datasetGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.EventTracker
  ): zio.aws.personalize.model.EventTracker.ReadOnly = new Wrapper(impl)
}
