package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  Status,
  ParameterName,
  ParameterValue,
  Date,
  Arn,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class FeatureTransformation(
    name: Optional[Name] = Optional.Absent,
    featureTransformationArn: Optional[Arn] = Optional.Absent,
    defaultParameters: Optional[Map[ParameterName, ParameterValue]] =
      Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent,
    status: Optional[Status] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.FeatureTransformation = {
    import FeatureTransformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.FeatureTransformation
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        featureTransformationArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.featureTransformationArn)
      .optionallyWith(
        defaultParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.defaultParameters)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.FeatureTransformation.ReadOnly =
    zio.aws.personalize.model.FeatureTransformation.wrap(buildAwsValue())
}
object FeatureTransformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.FeatureTransformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.FeatureTransformation =
      zio.aws.personalize.model.FeatureTransformation(
        name.map(value => value),
        featureTransformationArn.map(value => value),
        defaultParameters.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        status.map(value => value)
      )
    def name: Optional[Name]
    def featureTransformationArn: Optional[Arn]
    def defaultParameters: Optional[Map[ParameterName, ParameterValue]]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def status: Optional[Status]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getFeatureTransformationArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("featureTransformationArn", featureTransformationArn)
    def getDefaultParameters
        : ZIO[Any, AwsError, Map[ParameterName, ParameterValue]] =
      AwsError.unwrapOptionField("defaultParameters", defaultParameters)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.FeatureTransformation
  ) extends zio.aws.personalize.model.FeatureTransformation.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val featureTransformationArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.featureTransformationArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val defaultParameters
        : Optional[Map[ParameterName, ParameterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.personalize.model.primitives.ParameterName(
              key
            ) -> zio.aws.personalize.model.primitives.ParameterValue(value)
          })
          .toMap
      )
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.FeatureTransformation
  ): zio.aws.personalize.model.FeatureTransformation.ReadOnly = new Wrapper(
    impl
  )
}
