package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{MetricValue, MetricName, Arn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSolutionMetricsResponse(
    solutionVersionArn: Optional[Arn] = Optional.Absent,
    metrics: Optional[Map[MetricName, MetricValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.GetSolutionMetricsResponse = {
    import GetSolutionMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.GetSolutionMetricsResponse
      .builder()
      .optionallyWith(
        solutionVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionVersionArn)
      .optionallyWith(
        metrics.map(value =>
          value
            .map({ case (key, value) =>
              (MetricName.unwrap(key): java.lang.String) -> (MetricValue
                .unwrap(value): java.lang.Double)
            })
            .asJava
        )
      )(_.metrics)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.GetSolutionMetricsResponse.ReadOnly =
    zio.aws.personalize.model.GetSolutionMetricsResponse.wrap(buildAwsValue())
}
object GetSolutionMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.GetSolutionMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.GetSolutionMetricsResponse =
      zio.aws.personalize.model.GetSolutionMetricsResponse(
        solutionVersionArn.map(value => value),
        metrics.map(value => value)
      )
    def solutionVersionArn: Optional[Arn]
    def metrics: Optional[Map[MetricName, MetricValue]]
    def getSolutionVersionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionVersionArn", solutionVersionArn)
    def getMetrics: ZIO[Any, AwsError, Map[MetricName, MetricValue]] =
      AwsError.unwrapOptionField("metrics", metrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.GetSolutionMetricsResponse
  ) extends zio.aws.personalize.model.GetSolutionMetricsResponse.ReadOnly {
    override val solutionVersionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.solutionVersionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val metrics: Optional[Map[MetricName, MetricValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metrics())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.personalize.model.primitives.MetricName(
                key
              ) -> zio.aws.personalize.model.primitives.MetricValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.GetSolutionMetricsResponse
  ): zio.aws.personalize.model.GetSolutionMetricsResponse.ReadOnly =
    new Wrapper(impl)
}
