package zio.aws.personalize.model
import scala.jdk.CollectionConverters.*
sealed trait IngestionMode {
  def unwrap: software.amazon.awssdk.services.personalize.model.IngestionMode
}
object IngestionMode {
  def wrap(
      value: software.amazon.awssdk.services.personalize.model.IngestionMode
  ): zio.aws.personalize.model.IngestionMode = value match {
    case software.amazon.awssdk.services.personalize.model.IngestionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.personalize.model.IngestionMode.BULK =>
      val r = BULK
      r
    case software.amazon.awssdk.services.personalize.model.IngestionMode.PUT =>
      val r = PUT
      r
    case software.amazon.awssdk.services.personalize.model.IngestionMode.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.personalize.model.IngestionMode {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.IngestionMode =
      software.amazon.awssdk.services.personalize.model.IngestionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object BULK extends zio.aws.personalize.model.IngestionMode {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.IngestionMode =
      software.amazon.awssdk.services.personalize.model.IngestionMode.BULK
  }
  case object PUT extends zio.aws.personalize.model.IngestionMode {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.IngestionMode =
      software.amazon.awssdk.services.personalize.model.IngestionMode.PUT
  }
  case object ALL extends zio.aws.personalize.model.IngestionMode {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.IngestionMode =
      software.amazon.awssdk.services.personalize.model.IngestionMode.ALL
  }
}
