package zio.aws.personalize.model
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  IntegerMaxValue,
  IntegerMinValue,
  ParameterName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class IntegerHyperParameterRange(
    name: Optional[ParameterName] = Optional.Absent,
    minValue: Optional[IntegerMinValue] = Optional.Absent,
    maxValue: Optional[IntegerMaxValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.IntegerHyperParameterRange = {
    import IntegerHyperParameterRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.IntegerHyperParameterRange
      .builder()
      .optionallyWith(
        name.map(value => ParameterName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        minValue.map(value => IntegerMinValue.unwrap(value): Integer)
      )(_.minValue)
      .optionallyWith(
        maxValue.map(value => IntegerMaxValue.unwrap(value): Integer)
      )(_.maxValue)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.IntegerHyperParameterRange.ReadOnly =
    zio.aws.personalize.model.IntegerHyperParameterRange.wrap(buildAwsValue())
}
object IntegerHyperParameterRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.IntegerHyperParameterRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.IntegerHyperParameterRange =
      zio.aws.personalize.model.IntegerHyperParameterRange(
        name.map(value => value),
        minValue.map(value => value),
        maxValue.map(value => value)
      )
    def name: Optional[ParameterName]
    def minValue: Optional[IntegerMinValue]
    def maxValue: Optional[IntegerMaxValue]
    def getName: ZIO[Any, AwsError, ParameterName] =
      AwsError.unwrapOptionField("name", name)
    def getMinValue: ZIO[Any, AwsError, IntegerMinValue] =
      AwsError.unwrapOptionField("minValue", minValue)
    def getMaxValue: ZIO[Any, AwsError, IntegerMaxValue] =
      AwsError.unwrapOptionField("maxValue", maxValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.IntegerHyperParameterRange
  ) extends zio.aws.personalize.model.IntegerHyperParameterRange.ReadOnly {
    override val name: Optional[ParameterName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.ParameterName(value))
    override val minValue: Optional[IntegerMinValue] = zio.aws.core.internal
      .optionalFromNullable(impl.minValue())
      .map(value => zio.aws.personalize.model.primitives.IntegerMinValue(value))
    override val maxValue: Optional[IntegerMaxValue] = zio.aws.core.internal
      .optionalFromNullable(impl.maxValue())
      .map(value => zio.aws.personalize.model.primitives.IntegerMaxValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.IntegerHyperParameterRange
  ): zio.aws.personalize.model.IntegerHyperParameterRange.ReadOnly =
    new Wrapper(impl)
}
