package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListCampaignsResponse(
    campaigns: Optional[Iterable[zio.aws.personalize.model.CampaignSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListCampaignsResponse = {
    import ListCampaignsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListCampaignsResponse
      .builder()
      .optionallyWith(
        campaigns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.campaigns)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.ListCampaignsResponse.ReadOnly =
    zio.aws.personalize.model.ListCampaignsResponse.wrap(buildAwsValue())
}
object ListCampaignsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListCampaignsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListCampaignsResponse =
      zio.aws.personalize.model.ListCampaignsResponse(
        campaigns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def campaigns
        : Optional[List[zio.aws.personalize.model.CampaignSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getCampaigns: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.CampaignSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("campaigns", campaigns)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListCampaignsResponse
  ) extends zio.aws.personalize.model.ListCampaignsResponse.ReadOnly {
    override val campaigns
        : Optional[List[zio.aws.personalize.model.CampaignSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.campaigns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.CampaignSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListCampaignsResponse
  ): zio.aws.personalize.model.ListCampaignsResponse.ReadOnly = new Wrapper(
    impl
  )
}
