package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDatasetImportJobsResponse(
    datasetImportJobs: Optional[
      Iterable[zio.aws.personalize.model.DatasetImportJobSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsResponse = {
    import ListDatasetImportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsResponse
      .builder()
      .optionallyWith(
        datasetImportJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datasetImportJobs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.ListDatasetImportJobsResponse.ReadOnly =
    zio.aws.personalize.model.ListDatasetImportJobsResponse
      .wrap(buildAwsValue())
}
object ListDatasetImportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListDatasetImportJobsResponse =
      zio.aws.personalize.model.ListDatasetImportJobsResponse(
        datasetImportJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def datasetImportJobs: Optional[
      List[zio.aws.personalize.model.DatasetImportJobSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getDatasetImportJobs: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.DatasetImportJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("datasetImportJobs", datasetImportJobs)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsResponse
  ) extends zio.aws.personalize.model.ListDatasetImportJobsResponse.ReadOnly {
    override val datasetImportJobs: Optional[
      List[zio.aws.personalize.model.DatasetImportJobSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetImportJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.DatasetImportJobSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsResponse
  ): zio.aws.personalize.model.ListDatasetImportJobsResponse.ReadOnly =
    new Wrapper(impl)
}
