package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDatasetsResponse(
    datasets: Optional[Iterable[zio.aws.personalize.model.DatasetSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListDatasetsResponse = {
    import ListDatasetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListDatasetsResponse
      .builder()
      .optionallyWith(
        datasets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datasets)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.ListDatasetsResponse.ReadOnly =
    zio.aws.personalize.model.ListDatasetsResponse.wrap(buildAwsValue())
}
object ListDatasetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListDatasetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListDatasetsResponse =
      zio.aws.personalize.model.ListDatasetsResponse(
        datasets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def datasets
        : Optional[List[zio.aws.personalize.model.DatasetSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getDatasets: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.DatasetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("datasets", datasets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListDatasetsResponse
  ) extends zio.aws.personalize.model.ListDatasetsResponse.ReadOnly {
    override val datasets
        : Optional[List[zio.aws.personalize.model.DatasetSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.DatasetSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListDatasetsResponse
  ): zio.aws.personalize.model.ListDatasetsResponse.ReadOnly = new Wrapper(impl)
}
