package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListFiltersResponse(
    filters: Optional[Iterable[zio.aws.personalize.model.FilterSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListFiltersResponse = {
    import ListFiltersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListFiltersResponse
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.ListFiltersResponse.ReadOnly =
    zio.aws.personalize.model.ListFiltersResponse.wrap(buildAwsValue())
}
object ListFiltersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListFiltersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListFiltersResponse =
      zio.aws.personalize.model.ListFiltersResponse(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def filters
        : Optional[List[zio.aws.personalize.model.FilterSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.FilterSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListFiltersResponse
  ) extends zio.aws.personalize.model.ListFiltersResponse.ReadOnly {
    override val filters
        : Optional[List[zio.aws.personalize.model.FilterSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.FilterSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListFiltersResponse
  ): zio.aws.personalize.model.ListFiltersResponse.ReadOnly = new Wrapper(impl)
}
