package zio.aws.personalize.model
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{MaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListRecipesRequest(
    recipeProvider: Optional[zio.aws.personalize.model.RecipeProvider] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    domain: Optional[zio.aws.personalize.model.Domain] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListRecipesRequest = {
    import ListRecipesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListRecipesRequest
      .builder()
      .optionallyWith(recipeProvider.map(value => value.unwrap))(
        _.recipeProvider
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.ListRecipesRequest.ReadOnly =
    zio.aws.personalize.model.ListRecipesRequest.wrap(buildAwsValue())
}
object ListRecipesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListRecipesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListRecipesRequest =
      zio.aws.personalize.model.ListRecipesRequest(
        recipeProvider.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        domain.map(value => value)
      )
    def recipeProvider: Optional[zio.aws.personalize.model.RecipeProvider]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def domain: Optional[zio.aws.personalize.model.Domain]
    def getRecipeProvider
        : ZIO[Any, AwsError, zio.aws.personalize.model.RecipeProvider] =
      AwsError.unwrapOptionField("recipeProvider", recipeProvider)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getDomain: ZIO[Any, AwsError, zio.aws.personalize.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListRecipesRequest
  ) extends zio.aws.personalize.model.ListRecipesRequest.ReadOnly {
    override val recipeProvider
        : Optional[zio.aws.personalize.model.RecipeProvider] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recipeProvider())
        .map(value => zio.aws.personalize.model.RecipeProvider.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.personalize.model.primitives.MaxResults(value))
    override val domain: Optional[zio.aws.personalize.model.Domain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domain())
        .map(value => zio.aws.personalize.model.Domain.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListRecipesRequest
  ): zio.aws.personalize.model.ListRecipesRequest.ReadOnly = new Wrapper(impl)
}
