package zio.aws.personalize.model
import scala.jdk.CollectionConverters.*
sealed trait RecipeProvider {
  def unwrap: software.amazon.awssdk.services.personalize.model.RecipeProvider
}
object RecipeProvider {
  def wrap(
      value: software.amazon.awssdk.services.personalize.model.RecipeProvider
  ): zio.aws.personalize.model.RecipeProvider = value match {
    case software.amazon.awssdk.services.personalize.model.RecipeProvider.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.personalize.model.RecipeProvider.SERVICE =>
      val r = SERVICE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.personalize.model.RecipeProvider {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.RecipeProvider =
      software.amazon.awssdk.services.personalize.model.RecipeProvider.UNKNOWN_TO_SDK_VERSION
  }
  case object SERVICE extends zio.aws.personalize.model.RecipeProvider {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.RecipeProvider =
      software.amazon.awssdk.services.personalize.model.RecipeProvider.SERVICE
  }
}
