package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{Date, Status, Arn, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class RecommenderSummary(
    name: Optional[Name] = Optional.Absent,
    recommenderArn: Optional[Arn] = Optional.Absent,
    datasetGroupArn: Optional[Arn] = Optional.Absent,
    recipeArn: Optional[Arn] = Optional.Absent,
    recommenderConfig: Optional[zio.aws.personalize.model.RecommenderConfig] =
      Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.RecommenderSummary = {
    import RecommenderSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.RecommenderSummary
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        recommenderArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recommenderArn)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(
        recipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recipeArn)
      .optionallyWith(recommenderConfig.map(value => value.buildAwsValue()))(
        _.recommenderConfig
      )
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.RecommenderSummary.ReadOnly =
    zio.aws.personalize.model.RecommenderSummary.wrap(buildAwsValue())
}
object RecommenderSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.RecommenderSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.RecommenderSummary =
      zio.aws.personalize.model.RecommenderSummary(
        name.map(value => value),
        recommenderArn.map(value => value),
        datasetGroupArn.map(value => value),
        recipeArn.map(value => value),
        recommenderConfig.map(value => value.asEditable),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def name: Optional[Name]
    def recommenderArn: Optional[Arn]
    def datasetGroupArn: Optional[Arn]
    def recipeArn: Optional[Arn]
    def recommenderConfig
        : Optional[zio.aws.personalize.model.RecommenderConfig.ReadOnly]
    def status: Optional[Status]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getRecommenderArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recommenderArn", recommenderArn)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recipeArn", recipeArn)
    def getRecommenderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.RecommenderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("recommenderConfig", recommenderConfig)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.RecommenderSummary
  ) extends zio.aws.personalize.model.RecommenderSummary.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val recommenderArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.recommenderArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val datasetGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val recipeArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.recipeArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val recommenderConfig
        : Optional[zio.aws.personalize.model.RecommenderConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommenderConfig())
        .map(value => zio.aws.personalize.model.RecommenderConfig.wrap(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.RecommenderSummary
  ): zio.aws.personalize.model.RecommenderSummary.ReadOnly = new Wrapper(impl)
}
