package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  ParameterValue,
  ParameterName,
  EventValueThreshold
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SolutionConfig(
    eventValueThreshold: Optional[EventValueThreshold] = Optional.Absent,
    hpoConfig: Optional[zio.aws.personalize.model.HPOConfig] = Optional.Absent,
    algorithmHyperParameters: Optional[Map[ParameterName, ParameterValue]] =
      Optional.Absent,
    featureTransformationParameters: Optional[
      Map[ParameterName, ParameterValue]
    ] = Optional.Absent,
    autoMLConfig: Optional[zio.aws.personalize.model.AutoMLConfig] =
      Optional.Absent,
    optimizationObjective: Optional[
      zio.aws.personalize.model.OptimizationObjective
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.SolutionConfig = {
    import SolutionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.SolutionConfig
      .builder()
      .optionallyWith(
        eventValueThreshold.map(value =>
          EventValueThreshold.unwrap(value): java.lang.String
        )
      )(_.eventValueThreshold)
      .optionallyWith(hpoConfig.map(value => value.buildAwsValue()))(
        _.hpoConfig
      )
      .optionallyWith(
        algorithmHyperParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.algorithmHyperParameters)
      .optionallyWith(
        featureTransformationParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.featureTransformationParameters)
      .optionallyWith(autoMLConfig.map(value => value.buildAwsValue()))(
        _.autoMLConfig
      )
      .optionallyWith(
        optimizationObjective.map(value => value.buildAwsValue())
      )(_.optimizationObjective)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.SolutionConfig.ReadOnly =
    zio.aws.personalize.model.SolutionConfig.wrap(buildAwsValue())
}
object SolutionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.SolutionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.SolutionConfig =
      zio.aws.personalize.model.SolutionConfig(
        eventValueThreshold.map(value => value),
        hpoConfig.map(value => value.asEditable),
        algorithmHyperParameters.map(value => value),
        featureTransformationParameters.map(value => value),
        autoMLConfig.map(value => value.asEditable),
        optimizationObjective.map(value => value.asEditable)
      )
    def eventValueThreshold: Optional[EventValueThreshold]
    def hpoConfig: Optional[zio.aws.personalize.model.HPOConfig.ReadOnly]
    def algorithmHyperParameters: Optional[Map[ParameterName, ParameterValue]]
    def featureTransformationParameters
        : Optional[Map[ParameterName, ParameterValue]]
    def autoMLConfig: Optional[zio.aws.personalize.model.AutoMLConfig.ReadOnly]
    def optimizationObjective
        : Optional[zio.aws.personalize.model.OptimizationObjective.ReadOnly]
    def getEventValueThreshold: ZIO[Any, AwsError, EventValueThreshold] =
      AwsError.unwrapOptionField("eventValueThreshold", eventValueThreshold)
    def getHpoConfig
        : ZIO[Any, AwsError, zio.aws.personalize.model.HPOConfig.ReadOnly] =
      AwsError.unwrapOptionField("hpoConfig", hpoConfig)
    def getAlgorithmHyperParameters
        : ZIO[Any, AwsError, Map[ParameterName, ParameterValue]] = AwsError
      .unwrapOptionField("algorithmHyperParameters", algorithmHyperParameters)
    def getFeatureTransformationParameters
        : ZIO[Any, AwsError, Map[ParameterName, ParameterValue]] =
      AwsError.unwrapOptionField(
        "featureTransformationParameters",
        featureTransformationParameters
      )
    def getAutoMLConfig
        : ZIO[Any, AwsError, zio.aws.personalize.model.AutoMLConfig.ReadOnly] =
      AwsError.unwrapOptionField("autoMLConfig", autoMLConfig)
    def getOptimizationObjective: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.OptimizationObjective.ReadOnly
    ] =
      AwsError.unwrapOptionField("optimizationObjective", optimizationObjective)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.SolutionConfig
  ) extends zio.aws.personalize.model.SolutionConfig.ReadOnly {
    override val eventValueThreshold: Optional[EventValueThreshold] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventValueThreshold())
        .map(value =>
          zio.aws.personalize.model.primitives.EventValueThreshold(value)
        )
    override val hpoConfig
        : Optional[zio.aws.personalize.model.HPOConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hpoConfig())
        .map(value => zio.aws.personalize.model.HPOConfig.wrap(value))
    override val algorithmHyperParameters
        : Optional[Map[ParameterName, ParameterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.algorithmHyperParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.personalize.model.primitives.ParameterName(
              key
            ) -> zio.aws.personalize.model.primitives.ParameterValue(value)
          })
          .toMap
      )
    override val featureTransformationParameters
        : Optional[Map[ParameterName, ParameterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.featureTransformationParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.personalize.model.primitives.ParameterName(
              key
            ) -> zio.aws.personalize.model.primitives.ParameterValue(value)
          })
          .toMap
      )
    override val autoMLConfig
        : Optional[zio.aws.personalize.model.AutoMLConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMLConfig())
        .map(value => zio.aws.personalize.model.AutoMLConfig.wrap(value))
    override val optimizationObjective
        : Optional[zio.aws.personalize.model.OptimizationObjective.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optimizationObjective())
        .map(value =>
          zio.aws.personalize.model.OptimizationObjective.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.SolutionConfig
  ): zio.aws.personalize.model.SolutionConfig.ReadOnly = new Wrapper(impl)
}
