package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class StartRecommenderRequest(recommenderArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.StartRecommenderRequest = {
    import StartRecommenderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.StartRecommenderRequest
      .builder()
      .recommenderArn(Arn.unwrap(recommenderArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.StartRecommenderRequest.ReadOnly =
    zio.aws.personalize.model.StartRecommenderRequest.wrap(buildAwsValue())
}
object StartRecommenderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.StartRecommenderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.StartRecommenderRequest =
      zio.aws.personalize.model.StartRecommenderRequest(recommenderArn)
    def recommenderArn: Arn
    def getRecommenderArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(recommenderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.StartRecommenderRequest
  ) extends zio.aws.personalize.model.StartRecommenderRequest.ReadOnly {
    override val recommenderArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.recommenderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.StartRecommenderRequest
  ): zio.aws.personalize.model.StartRecommenderRequest.ReadOnly = new Wrapper(
    impl
  )
}
