package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartRecommenderResponse(
    recommenderArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.StartRecommenderResponse = {
    import StartRecommenderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.StartRecommenderResponse
      .builder()
      .optionallyWith(
        recommenderArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recommenderArn)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.StartRecommenderResponse.ReadOnly =
    zio.aws.personalize.model.StartRecommenderResponse.wrap(buildAwsValue())
}
object StartRecommenderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.StartRecommenderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.StartRecommenderResponse =
      zio.aws.personalize.model
        .StartRecommenderResponse(recommenderArn.map(value => value))
    def recommenderArn: Optional[Arn]
    def getRecommenderArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recommenderArn", recommenderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.StartRecommenderResponse
  ) extends zio.aws.personalize.model.StartRecommenderResponse.ReadOnly {
    override val recommenderArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.recommenderArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.StartRecommenderResponse
  ): zio.aws.personalize.model.StartRecommenderResponse.ReadOnly = new Wrapper(
    impl
  )
}
