package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class StopRecommenderRequest(recommenderArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.StopRecommenderRequest = {
    import StopRecommenderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.StopRecommenderRequest
      .builder()
      .recommenderArn(Arn.unwrap(recommenderArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.StopRecommenderRequest.ReadOnly =
    zio.aws.personalize.model.StopRecommenderRequest.wrap(buildAwsValue())
}
object StopRecommenderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.StopRecommenderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.StopRecommenderRequest =
      zio.aws.personalize.model.StopRecommenderRequest(recommenderArn)
    def recommenderArn: Arn
    def getRecommenderArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(recommenderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.StopRecommenderRequest
  ) extends zio.aws.personalize.model.StopRecommenderRequest.ReadOnly {
    override val recommenderArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.recommenderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.StopRecommenderRequest
  ): zio.aws.personalize.model.StopRecommenderRequest.ReadOnly = new Wrapper(
    impl
  )
}
