package zio.aws.personalize
import zio.aws.personalize.model.CreateSolutionResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.personalize.PersonalizeAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.personalize.model.{
  DescribeAlgorithmRequest,
  UpdateRecommenderRequest,
  ListDatasetExportJobsRequest,
  CreateDatasetRequest,
  DescribeDatasetGroupRequest,
  DescribeSchemaRequest,
  DescribeCampaignRequest,
  CreateEventTrackerRequest,
  DeleteEventTrackerRequest,
  DescribeFilterRequest,
  CreateDatasetExportJobRequest,
  DeleteDatasetGroupRequest,
  DescribeEventTrackerRequest,
  DescribeDatasetRequest,
  ListSchemasRequest,
  ListTagsForResourceRequest,
  ListDatasetImportJobsRequest,
  DescribeBatchSegmentJobRequest,
  CreateSchemaRequest,
  ListEventTrackersRequest,
  DescribeDatasetImportJobRequest,
  CreateDatasetGroupRequest,
  UpdateCampaignRequest,
  DescribeRecipeRequest,
  DeleteSolutionRequest,
  ListDatasetsRequest,
  ListRecommendersRequest,
  CreateFilterRequest,
  DescribeSolutionVersionRequest,
  ListBatchInferenceJobsRequest,
  ListFiltersRequest,
  CreateSolutionVersionRequest,
  StopSolutionVersionCreationRequest,
  CreateCampaignRequest,
  DeleteRecommenderRequest,
  DescribeDatasetExportJobRequest,
  DeleteCampaignRequest,
  CreateRecommenderRequest,
  DeleteDatasetRequest,
  CreateBatchSegmentJobRequest,
  CreateBatchInferenceJobRequest,
  DescribeRecommenderRequest,
  DescribeSolutionRequest,
  UntagResourceRequest,
  DescribeFeatureTransformationRequest,
  ListDatasetGroupsRequest,
  DeleteFilterRequest,
  ListRecipesRequest,
  StartRecommenderRequest,
  ListCampaignsRequest,
  ListSolutionsRequest,
  CreateSolutionRequest,
  StopRecommenderRequest,
  DeleteSchemaRequest,
  DescribeBatchInferenceJobRequest,
  ListSolutionVersionsRequest,
  GetSolutionMetricsRequest,
  ListBatchSegmentJobsRequest,
  TagResourceRequest,
  CreateDatasetImportJobRequest
}
import zio.stream.ZStream
object PersonalizeMock extends Mock[Personalize] {
  object GetSolutionMetrics
      extends Effect[
        GetSolutionMetricsRequest,
        AwsError,
        zio.aws.personalize.model.GetSolutionMetricsResponse.ReadOnly
      ]
  object CreateDataset
      extends Effect[
        CreateDatasetRequest,
        AwsError,
        zio.aws.personalize.model.CreateDatasetResponse.ReadOnly
      ]
  object CreateEventTracker
      extends Effect[
        CreateEventTrackerRequest,
        AwsError,
        zio.aws.personalize.model.CreateEventTrackerResponse.ReadOnly
      ]
  object DeleteCampaign extends Effect[DeleteCampaignRequest, AwsError, Unit]
  object DescribeAlgorithm
      extends Effect[
        DescribeAlgorithmRequest,
        AwsError,
        zio.aws.personalize.model.DescribeAlgorithmResponse.ReadOnly
      ]
  object DescribeDatasetExportJob
      extends Effect[
        DescribeDatasetExportJobRequest,
        AwsError,
        zio.aws.personalize.model.DescribeDatasetExportJobResponse.ReadOnly
      ]
  object ListCampaigns
      extends Stream[
        ListCampaignsRequest,
        AwsError,
        zio.aws.personalize.model.CampaignSummary.ReadOnly
      ]
  object ListCampaignsPaginated
      extends Effect[
        ListCampaignsRequest,
        AwsError,
        zio.aws.personalize.model.ListCampaignsResponse.ReadOnly
      ]
  object CreateDatasetGroup
      extends Effect[
        CreateDatasetGroupRequest,
        AwsError,
        zio.aws.personalize.model.CreateDatasetGroupResponse.ReadOnly
      ]
  object DeleteFilter extends Effect[DeleteFilterRequest, AwsError, Unit]
  object DeleteRecommender
      extends Effect[DeleteRecommenderRequest, AwsError, Unit]
  object CreateSolution
      extends Effect[CreateSolutionRequest, AwsError, ReadOnly]
  object DescribeBatchSegmentJob
      extends Effect[
        DescribeBatchSegmentJobRequest,
        AwsError,
        zio.aws.personalize.model.DescribeBatchSegmentJobResponse.ReadOnly
      ]
  object CreateRecommender
      extends Effect[
        CreateRecommenderRequest,
        AwsError,
        zio.aws.personalize.model.CreateRecommenderResponse.ReadOnly
      ]
  object DescribeBatchInferenceJob
      extends Effect[
        DescribeBatchInferenceJobRequest,
        AwsError,
        zio.aws.personalize.model.DescribeBatchInferenceJobResponse.ReadOnly
      ]
  object DescribeCampaign
      extends Effect[
        DescribeCampaignRequest,
        AwsError,
        zio.aws.personalize.model.DescribeCampaignResponse.ReadOnly
      ]
  object CreateFilter
      extends Effect[
        CreateFilterRequest,
        AwsError,
        zio.aws.personalize.model.CreateFilterResponse.ReadOnly
      ]
  object ListSolutions
      extends Stream[
        ListSolutionsRequest,
        AwsError,
        zio.aws.personalize.model.SolutionSummary.ReadOnly
      ]
  object ListSolutionsPaginated
      extends Effect[
        ListSolutionsRequest,
        AwsError,
        zio.aws.personalize.model.ListSolutionsResponse.ReadOnly
      ]
  object DescribeDatasetImportJob
      extends Effect[
        DescribeDatasetImportJobRequest,
        AwsError,
        zio.aws.personalize.model.DescribeDatasetImportJobResponse.ReadOnly
      ]
  object DescribeSolution
      extends Effect[
        DescribeSolutionRequest,
        AwsError,
        zio.aws.personalize.model.DescribeSolutionResponse.ReadOnly
      ]
  object ListEventTrackers
      extends Stream[
        ListEventTrackersRequest,
        AwsError,
        zio.aws.personalize.model.EventTrackerSummary.ReadOnly
      ]
  object ListEventTrackersPaginated
      extends Effect[
        ListEventTrackersRequest,
        AwsError,
        zio.aws.personalize.model.ListEventTrackersResponse.ReadOnly
      ]
  object StartRecommender
      extends Effect[
        StartRecommenderRequest,
        AwsError,
        zio.aws.personalize.model.StartRecommenderResponse.ReadOnly
      ]
  object DescribeDataset
      extends Effect[
        DescribeDatasetRequest,
        AwsError,
        zio.aws.personalize.model.DescribeDatasetResponse.ReadOnly
      ]
  object CreateDatasetImportJob
      extends Effect[
        CreateDatasetImportJobRequest,
        AwsError,
        zio.aws.personalize.model.CreateDatasetImportJobResponse.ReadOnly
      ]
  object DescribeSchema
      extends Effect[
        DescribeSchemaRequest,
        AwsError,
        zio.aws.personalize.model.DescribeSchemaResponse.ReadOnly
      ]
  object CreateSolutionVersion
      extends Effect[
        CreateSolutionVersionRequest,
        AwsError,
        zio.aws.personalize.model.CreateSolutionVersionResponse.ReadOnly
      ]
  object CreateDatasetExportJob
      extends Effect[
        CreateDatasetExportJobRequest,
        AwsError,
        zio.aws.personalize.model.CreateDatasetExportJobResponse.ReadOnly
      ]
  object DescribeRecipe
      extends Effect[
        DescribeRecipeRequest,
        AwsError,
        zio.aws.personalize.model.DescribeRecipeResponse.ReadOnly
      ]
  object DeleteSolution extends Effect[DeleteSolutionRequest, AwsError, Unit]
  object UpdateRecommender
      extends Effect[
        UpdateRecommenderRequest,
        AwsError,
        zio.aws.personalize.model.UpdateRecommenderResponse.ReadOnly
      ]
  object DeleteDatasetGroup
      extends Effect[DeleteDatasetGroupRequest, AwsError, Unit]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.personalize.model.UntagResourceResponse.ReadOnly
      ]
  object ListDatasetGroups
      extends Stream[
        ListDatasetGroupsRequest,
        AwsError,
        zio.aws.personalize.model.DatasetGroupSummary.ReadOnly
      ]
  object ListDatasetGroupsPaginated
      extends Effect[
        ListDatasetGroupsRequest,
        AwsError,
        zio.aws.personalize.model.ListDatasetGroupsResponse.ReadOnly
      ]
  object CreateBatchInferenceJob
      extends Effect[
        CreateBatchInferenceJobRequest,
        AwsError,
        zio.aws.personalize.model.CreateBatchInferenceJobResponse.ReadOnly
      ]
  object StopSolutionVersionCreation
      extends Effect[StopSolutionVersionCreationRequest, AwsError, Unit]
  object ListFilters
      extends Stream[
        ListFiltersRequest,
        AwsError,
        zio.aws.personalize.model.FilterSummary.ReadOnly
      ]
  object ListFiltersPaginated
      extends Effect[
        ListFiltersRequest,
        AwsError,
        zio.aws.personalize.model.ListFiltersResponse.ReadOnly
      ]
  object DescribeDatasetGroup
      extends Effect[
        DescribeDatasetGroupRequest,
        AwsError,
        zio.aws.personalize.model.DescribeDatasetGroupResponse.ReadOnly
      ]
  object DescribeEventTracker
      extends Effect[
        DescribeEventTrackerRequest,
        AwsError,
        zio.aws.personalize.model.DescribeEventTrackerResponse.ReadOnly
      ]
  object ListRecommenders
      extends Stream[
        ListRecommendersRequest,
        AwsError,
        zio.aws.personalize.model.RecommenderSummary.ReadOnly
      ]
  object ListRecommendersPaginated
      extends Effect[
        ListRecommendersRequest,
        AwsError,
        zio.aws.personalize.model.ListRecommendersResponse.ReadOnly
      ]
  object ListDatasets
      extends Stream[
        ListDatasetsRequest,
        AwsError,
        zio.aws.personalize.model.DatasetSummary.ReadOnly
      ]
  object ListDatasetsPaginated
      extends Effect[
        ListDatasetsRequest,
        AwsError,
        zio.aws.personalize.model.ListDatasetsResponse.ReadOnly
      ]
  object DescribeSolutionVersion
      extends Effect[
        DescribeSolutionVersionRequest,
        AwsError,
        zio.aws.personalize.model.DescribeSolutionVersionResponse.ReadOnly
      ]
  object CreateCampaign
      extends Effect[
        CreateCampaignRequest,
        AwsError,
        zio.aws.personalize.model.CreateCampaignResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.personalize.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DeleteEventTracker
      extends Effect[DeleteEventTrackerRequest, AwsError, Unit]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.personalize.model.TagResourceResponse.ReadOnly
      ]
  object ListDatasetImportJobs
      extends Stream[
        ListDatasetImportJobsRequest,
        AwsError,
        zio.aws.personalize.model.DatasetImportJobSummary.ReadOnly
      ]
  object ListDatasetImportJobsPaginated
      extends Effect[
        ListDatasetImportJobsRequest,
        AwsError,
        zio.aws.personalize.model.ListDatasetImportJobsResponse.ReadOnly
      ]
  object ListBatchInferenceJobs
      extends Stream[
        ListBatchInferenceJobsRequest,
        AwsError,
        zio.aws.personalize.model.BatchInferenceJobSummary.ReadOnly
      ]
  object ListBatchInferenceJobsPaginated
      extends Effect[
        ListBatchInferenceJobsRequest,
        AwsError,
        zio.aws.personalize.model.ListBatchInferenceJobsResponse.ReadOnly
      ]
  object CreateSchema
      extends Effect[
        CreateSchemaRequest,
        AwsError,
        zio.aws.personalize.model.CreateSchemaResponse.ReadOnly
      ]
  object ListBatchSegmentJobs
      extends Stream[
        ListBatchSegmentJobsRequest,
        AwsError,
        zio.aws.personalize.model.BatchSegmentJobSummary.ReadOnly
      ]
  object ListBatchSegmentJobsPaginated
      extends Effect[
        ListBatchSegmentJobsRequest,
        AwsError,
        zio.aws.personalize.model.ListBatchSegmentJobsResponse.ReadOnly
      ]
  object DescribeFilter
      extends Effect[
        DescribeFilterRequest,
        AwsError,
        zio.aws.personalize.model.DescribeFilterResponse.ReadOnly
      ]
  object ListDatasetExportJobs
      extends Stream[
        ListDatasetExportJobsRequest,
        AwsError,
        zio.aws.personalize.model.DatasetExportJobSummary.ReadOnly
      ]
  object ListDatasetExportJobsPaginated
      extends Effect[
        ListDatasetExportJobsRequest,
        AwsError,
        zio.aws.personalize.model.ListDatasetExportJobsResponse.ReadOnly
      ]
  object DescribeFeatureTransformation
      extends Effect[
        DescribeFeatureTransformationRequest,
        AwsError,
        zio.aws.personalize.model.DescribeFeatureTransformationResponse.ReadOnly
      ]
  object DeleteSchema extends Effect[DeleteSchemaRequest, AwsError, Unit]
  object DeleteDataset extends Effect[DeleteDatasetRequest, AwsError, Unit]
  object ListSolutionVersions
      extends Stream[
        ListSolutionVersionsRequest,
        AwsError,
        zio.aws.personalize.model.SolutionVersionSummary.ReadOnly
      ]
  object ListSolutionVersionsPaginated
      extends Effect[
        ListSolutionVersionsRequest,
        AwsError,
        zio.aws.personalize.model.ListSolutionVersionsResponse.ReadOnly
      ]
  object DescribeRecommender
      extends Effect[
        DescribeRecommenderRequest,
        AwsError,
        zio.aws.personalize.model.DescribeRecommenderResponse.ReadOnly
      ]
  object ListSchemas
      extends Stream[
        ListSchemasRequest,
        AwsError,
        zio.aws.personalize.model.DatasetSchemaSummary.ReadOnly
      ]
  object ListSchemasPaginated
      extends Effect[
        ListSchemasRequest,
        AwsError,
        zio.aws.personalize.model.ListSchemasResponse.ReadOnly
      ]
  object StopRecommender
      extends Effect[
        StopRecommenderRequest,
        AwsError,
        zio.aws.personalize.model.StopRecommenderResponse.ReadOnly
      ]
  object CreateBatchSegmentJob
      extends Effect[
        CreateBatchSegmentJobRequest,
        AwsError,
        zio.aws.personalize.model.CreateBatchSegmentJobResponse.ReadOnly
      ]
  object ListRecipes
      extends Stream[
        ListRecipesRequest,
        AwsError,
        zio.aws.personalize.model.RecipeSummary.ReadOnly
      ]
  object ListRecipesPaginated
      extends Effect[
        ListRecipesRequest,
        AwsError,
        zio.aws.personalize.model.ListRecipesResponse.ReadOnly
      ]
  object UpdateCampaign
      extends Effect[
        UpdateCampaignRequest,
        AwsError,
        zio.aws.personalize.model.UpdateCampaignResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Personalize] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Personalize] { rts =>
        zio.ZIO.succeed {
          new Personalize {
            val api: PersonalizeAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Personalize = this
            def getSolutionMetrics(request: GetSolutionMetricsRequest): IO[
              AwsError,
              zio.aws.personalize.model.GetSolutionMetricsResponse.ReadOnly
            ] = proxy(GetSolutionMetrics, request)
            def createDataset(request: CreateDatasetRequest): IO[
              AwsError,
              zio.aws.personalize.model.CreateDatasetResponse.ReadOnly
            ] = proxy(CreateDataset, request)
            def createEventTracker(request: CreateEventTrackerRequest): IO[
              AwsError,
              zio.aws.personalize.model.CreateEventTrackerResponse.ReadOnly
            ] = proxy(CreateEventTracker, request)
            def deleteCampaign(
                request: DeleteCampaignRequest
            ): IO[AwsError, Unit] = proxy(DeleteCampaign, request)
            def describeAlgorithm(request: DescribeAlgorithmRequest): IO[
              AwsError,
              zio.aws.personalize.model.DescribeAlgorithmResponse.ReadOnly
            ] = proxy(DescribeAlgorithm, request)
            def describeDatasetExportJob(
                request: DescribeDatasetExportJobRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.DescribeDatasetExportJobResponse.ReadOnly
            ] = proxy(DescribeDatasetExportJob, request)
            def listCampaigns(request: ListCampaignsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.personalize.model.CampaignSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCampaigns, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCampaignsPaginated(request: ListCampaignsRequest): IO[
              AwsError,
              zio.aws.personalize.model.ListCampaignsResponse.ReadOnly
            ] = proxy(ListCampaignsPaginated, request)
            def createDatasetGroup(request: CreateDatasetGroupRequest): IO[
              AwsError,
              zio.aws.personalize.model.CreateDatasetGroupResponse.ReadOnly
            ] = proxy(CreateDatasetGroup, request)
            def deleteFilter(request: DeleteFilterRequest): IO[AwsError, Unit] =
              proxy(DeleteFilter, request)
            def deleteRecommender(
                request: DeleteRecommenderRequest
            ): IO[AwsError, Unit] = proxy(DeleteRecommender, request)
            def createSolution(
                request: CreateSolutionRequest
            ): IO[AwsError, ReadOnly] = proxy(CreateSolution, request)
            def describeBatchSegmentJob(
                request: DescribeBatchSegmentJobRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.DescribeBatchSegmentJobResponse.ReadOnly
            ] = proxy(DescribeBatchSegmentJob, request)
            def createRecommender(request: CreateRecommenderRequest): IO[
              AwsError,
              zio.aws.personalize.model.CreateRecommenderResponse.ReadOnly
            ] = proxy(CreateRecommender, request)
            def describeBatchInferenceJob(
                request: DescribeBatchInferenceJobRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.DescribeBatchInferenceJobResponse.ReadOnly
            ] = proxy(DescribeBatchInferenceJob, request)
            def describeCampaign(request: DescribeCampaignRequest): IO[
              AwsError,
              zio.aws.personalize.model.DescribeCampaignResponse.ReadOnly
            ] = proxy(DescribeCampaign, request)
            def createFilter(request: CreateFilterRequest): IO[
              AwsError,
              zio.aws.personalize.model.CreateFilterResponse.ReadOnly
            ] = proxy(CreateFilter, request)
            def listSolutions(request: ListSolutionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.personalize.model.SolutionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSolutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSolutionsPaginated(request: ListSolutionsRequest): IO[
              AwsError,
              zio.aws.personalize.model.ListSolutionsResponse.ReadOnly
            ] = proxy(ListSolutionsPaginated, request)
            def describeDatasetImportJob(
                request: DescribeDatasetImportJobRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.DescribeDatasetImportJobResponse.ReadOnly
            ] = proxy(DescribeDatasetImportJob, request)
            def describeSolution(request: DescribeSolutionRequest): IO[
              AwsError,
              zio.aws.personalize.model.DescribeSolutionResponse.ReadOnly
            ] = proxy(DescribeSolution, request)
            def listEventTrackers(request: ListEventTrackersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.personalize.model.EventTrackerSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEventTrackers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEventTrackersPaginated(
                request: ListEventTrackersRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.ListEventTrackersResponse.ReadOnly
            ] = proxy(ListEventTrackersPaginated, request)
            def startRecommender(request: StartRecommenderRequest): IO[
              AwsError,
              zio.aws.personalize.model.StartRecommenderResponse.ReadOnly
            ] = proxy(StartRecommender, request)
            def describeDataset(request: DescribeDatasetRequest): IO[
              AwsError,
              zio.aws.personalize.model.DescribeDatasetResponse.ReadOnly
            ] = proxy(DescribeDataset, request)
            def createDatasetImportJob(
                request: CreateDatasetImportJobRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.CreateDatasetImportJobResponse.ReadOnly
            ] = proxy(CreateDatasetImportJob, request)
            def describeSchema(request: DescribeSchemaRequest): IO[
              AwsError,
              zio.aws.personalize.model.DescribeSchemaResponse.ReadOnly
            ] = proxy(DescribeSchema, request)
            def createSolutionVersion(
                request: CreateSolutionVersionRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.CreateSolutionVersionResponse.ReadOnly
            ] = proxy(CreateSolutionVersion, request)
            def createDatasetExportJob(
                request: CreateDatasetExportJobRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.CreateDatasetExportJobResponse.ReadOnly
            ] = proxy(CreateDatasetExportJob, request)
            def describeRecipe(request: DescribeRecipeRequest): IO[
              AwsError,
              zio.aws.personalize.model.DescribeRecipeResponse.ReadOnly
            ] = proxy(DescribeRecipe, request)
            def deleteSolution(
                request: DeleteSolutionRequest
            ): IO[AwsError, Unit] = proxy(DeleteSolution, request)
            def updateRecommender(request: UpdateRecommenderRequest): IO[
              AwsError,
              zio.aws.personalize.model.UpdateRecommenderResponse.ReadOnly
            ] = proxy(UpdateRecommender, request)
            def deleteDatasetGroup(
                request: DeleteDatasetGroupRequest
            ): IO[AwsError, Unit] = proxy(DeleteDatasetGroup, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.personalize.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listDatasetGroups(request: ListDatasetGroupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.personalize.model.DatasetGroupSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDatasetGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDatasetGroupsPaginated(
                request: ListDatasetGroupsRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.ListDatasetGroupsResponse.ReadOnly
            ] = proxy(ListDatasetGroupsPaginated, request)
            def createBatchInferenceJob(
                request: CreateBatchInferenceJobRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.CreateBatchInferenceJobResponse.ReadOnly
            ] = proxy(CreateBatchInferenceJob, request)
            def stopSolutionVersionCreation(
                request: StopSolutionVersionCreationRequest
            ): IO[AwsError, Unit] = proxy(StopSolutionVersionCreation, request)
            def listFilters(request: ListFiltersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.personalize.model.FilterSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFilters, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFiltersPaginated(request: ListFiltersRequest): IO[
              AwsError,
              zio.aws.personalize.model.ListFiltersResponse.ReadOnly
            ] = proxy(ListFiltersPaginated, request)
            def describeDatasetGroup(request: DescribeDatasetGroupRequest): IO[
              AwsError,
              zio.aws.personalize.model.DescribeDatasetGroupResponse.ReadOnly
            ] = proxy(DescribeDatasetGroup, request)
            def describeEventTracker(request: DescribeEventTrackerRequest): IO[
              AwsError,
              zio.aws.personalize.model.DescribeEventTrackerResponse.ReadOnly
            ] = proxy(DescribeEventTracker, request)
            def listRecommenders(request: ListRecommendersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.personalize.model.RecommenderSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRecommenders, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRecommendersPaginated(request: ListRecommendersRequest): IO[
              AwsError,
              zio.aws.personalize.model.ListRecommendersResponse.ReadOnly
            ] = proxy(ListRecommendersPaginated, request)
            def listDatasets(request: ListDatasetsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.personalize.model.DatasetSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDatasets, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDatasetsPaginated(request: ListDatasetsRequest): IO[
              AwsError,
              zio.aws.personalize.model.ListDatasetsResponse.ReadOnly
            ] = proxy(ListDatasetsPaginated, request)
            def describeSolutionVersion(
                request: DescribeSolutionVersionRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.DescribeSolutionVersionResponse.ReadOnly
            ] = proxy(DescribeSolutionVersion, request)
            def createCampaign(request: CreateCampaignRequest): IO[
              AwsError,
              zio.aws.personalize.model.CreateCampaignResponse.ReadOnly
            ] = proxy(CreateCampaign, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.personalize.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def deleteEventTracker(
                request: DeleteEventTrackerRequest
            ): IO[AwsError, Unit] = proxy(DeleteEventTracker, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.personalize.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listDatasetImportJobs(
                request: ListDatasetImportJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.personalize.model.DatasetImportJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDatasetImportJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDatasetImportJobsPaginated(
                request: ListDatasetImportJobsRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.ListDatasetImportJobsResponse.ReadOnly
            ] = proxy(ListDatasetImportJobsPaginated, request)
            def listBatchInferenceJobs(
                request: ListBatchInferenceJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.personalize.model.BatchInferenceJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListBatchInferenceJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listBatchInferenceJobsPaginated(
                request: ListBatchInferenceJobsRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.ListBatchInferenceJobsResponse.ReadOnly
            ] = proxy(ListBatchInferenceJobsPaginated, request)
            def createSchema(request: CreateSchemaRequest): IO[
              AwsError,
              zio.aws.personalize.model.CreateSchemaResponse.ReadOnly
            ] = proxy(CreateSchema, request)
            def listBatchSegmentJobs(
                request: ListBatchSegmentJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.personalize.model.BatchSegmentJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListBatchSegmentJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listBatchSegmentJobsPaginated(
                request: ListBatchSegmentJobsRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.ListBatchSegmentJobsResponse.ReadOnly
            ] = proxy(ListBatchSegmentJobsPaginated, request)
            def describeFilter(request: DescribeFilterRequest): IO[
              AwsError,
              zio.aws.personalize.model.DescribeFilterResponse.ReadOnly
            ] = proxy(DescribeFilter, request)
            def listDatasetExportJobs(
                request: ListDatasetExportJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.personalize.model.DatasetExportJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDatasetExportJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDatasetExportJobsPaginated(
                request: ListDatasetExportJobsRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.ListDatasetExportJobsResponse.ReadOnly
            ] = proxy(ListDatasetExportJobsPaginated, request)
            def describeFeatureTransformation(
                request: DescribeFeatureTransformationRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.DescribeFeatureTransformationResponse.ReadOnly
            ] = proxy(DescribeFeatureTransformation, request)
            def deleteSchema(request: DeleteSchemaRequest): IO[AwsError, Unit] =
              proxy(DeleteSchema, request)
            def deleteDataset(
                request: DeleteDatasetRequest
            ): IO[AwsError, Unit] = proxy(DeleteDataset, request)
            def listSolutionVersions(
                request: ListSolutionVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.personalize.model.SolutionVersionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSolutionVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSolutionVersionsPaginated(
                request: ListSolutionVersionsRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.ListSolutionVersionsResponse.ReadOnly
            ] = proxy(ListSolutionVersionsPaginated, request)
            def describeRecommender(request: DescribeRecommenderRequest): IO[
              AwsError,
              zio.aws.personalize.model.DescribeRecommenderResponse.ReadOnly
            ] = proxy(DescribeRecommender, request)
            def listSchemas(request: ListSchemasRequest): ZStream[
              Any,
              AwsError,
              zio.aws.personalize.model.DatasetSchemaSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSchemas, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSchemasPaginated(request: ListSchemasRequest): IO[
              AwsError,
              zio.aws.personalize.model.ListSchemasResponse.ReadOnly
            ] = proxy(ListSchemasPaginated, request)
            def stopRecommender(request: StopRecommenderRequest): IO[
              AwsError,
              zio.aws.personalize.model.StopRecommenderResponse.ReadOnly
            ] = proxy(StopRecommender, request)
            def createBatchSegmentJob(
                request: CreateBatchSegmentJobRequest
            ): IO[
              AwsError,
              zio.aws.personalize.model.CreateBatchSegmentJobResponse.ReadOnly
            ] = proxy(CreateBatchSegmentJob, request)
            def listRecipes(request: ListRecipesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.personalize.model.RecipeSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRecipes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRecipesPaginated(request: ListRecipesRequest): IO[
              AwsError,
              zio.aws.personalize.model.ListRecipesResponse.ReadOnly
            ] = proxy(ListRecipesPaginated, request)
            def updateCampaign(request: UpdateCampaignRequest): IO[
              AwsError,
              zio.aws.personalize.model.UpdateCampaignResponse.ReadOnly
            ] = proxy(UpdateCampaign, request)
          }
        }
      }
    }
  }
}
