package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  ParameterName,
  ParameterValue,
  Date,
  Arn,
  TrainingInputMode,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Algorithm(
    name: Optional[Name] = Optional.Absent,
    algorithmArn: Optional[Arn] = Optional.Absent,
    algorithmImage: Optional[zio.aws.personalize.model.AlgorithmImage] =
      Optional.Absent,
    defaultHyperParameters: Optional[Map[ParameterName, ParameterValue]] =
      Optional.Absent,
    defaultHyperParameterRanges: Optional[
      zio.aws.personalize.model.DefaultHyperParameterRanges
    ] = Optional.Absent,
    defaultResourceConfig: Optional[Map[ParameterName, ParameterValue]] =
      Optional.Absent,
    trainingInputMode: Optional[TrainingInputMode] = Optional.Absent,
    roleArn: Optional[Arn] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.Algorithm = {
    import Algorithm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.Algorithm
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        algorithmArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.algorithmArn)
      .optionallyWith(algorithmImage.map(value => value.buildAwsValue()))(
        _.algorithmImage
      )
      .optionallyWith(
        defaultHyperParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.defaultHyperParameters)
      .optionallyWith(
        defaultHyperParameterRanges.map(value => value.buildAwsValue())
      )(_.defaultHyperParameterRanges)
      .optionallyWith(
        defaultResourceConfig.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.defaultResourceConfig)
      .optionallyWith(
        trainingInputMode.map(value =>
          TrainingInputMode.unwrap(value): java.lang.String
        )
      )(_.trainingInputMode)
      .optionallyWith(
        roleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.Algorithm.ReadOnly =
    zio.aws.personalize.model.Algorithm.wrap(buildAwsValue())
}
object Algorithm {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.Algorithm
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.Algorithm =
      zio.aws.personalize.model.Algorithm(
        name.map(value => value),
        algorithmArn.map(value => value),
        algorithmImage.map(value => value.asEditable),
        defaultHyperParameters.map(value => value),
        defaultHyperParameterRanges.map(value => value.asEditable),
        defaultResourceConfig.map(value => value),
        trainingInputMode.map(value => value),
        roleArn.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def name: Optional[Name]
    def algorithmArn: Optional[Arn]
    def algorithmImage
        : Optional[zio.aws.personalize.model.AlgorithmImage.ReadOnly]
    def defaultHyperParameters: Optional[Map[ParameterName, ParameterValue]]
    def defaultHyperParameterRanges: Optional[
      zio.aws.personalize.model.DefaultHyperParameterRanges.ReadOnly
    ]
    def defaultResourceConfig: Optional[Map[ParameterName, ParameterValue]]
    def trainingInputMode: Optional[TrainingInputMode]
    def roleArn: Optional[Arn]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getAlgorithmArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("algorithmArn", algorithmArn)
    def getAlgorithmImage: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.AlgorithmImage.ReadOnly
    ] = AwsError.unwrapOptionField("algorithmImage", algorithmImage)
    def getDefaultHyperParameters
        : ZIO[Any, AwsError, Map[ParameterName, ParameterValue]] = AwsError
      .unwrapOptionField("defaultHyperParameters", defaultHyperParameters)
    def getDefaultHyperParameterRanges: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.DefaultHyperParameterRanges.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultHyperParameterRanges",
      defaultHyperParameterRanges
    )
    def getDefaultResourceConfig
        : ZIO[Any, AwsError, Map[ParameterName, ParameterValue]] =
      AwsError.unwrapOptionField("defaultResourceConfig", defaultResourceConfig)
    def getTrainingInputMode: ZIO[Any, AwsError, TrainingInputMode] =
      AwsError.unwrapOptionField("trainingInputMode", trainingInputMode)
    def getRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.Algorithm
  ) extends zio.aws.personalize.model.Algorithm.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val algorithmArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.algorithmArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val algorithmImage
        : Optional[zio.aws.personalize.model.AlgorithmImage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.algorithmImage())
        .map(value => zio.aws.personalize.model.AlgorithmImage.wrap(value))
    override val defaultHyperParameters
        : Optional[Map[ParameterName, ParameterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultHyperParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.personalize.model.primitives.ParameterName(
              key
            ) -> zio.aws.personalize.model.primitives.ParameterValue(value)
          })
          .toMap
      )
    override val defaultHyperParameterRanges: Optional[
      zio.aws.personalize.model.DefaultHyperParameterRanges.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultHyperParameterRanges())
      .map(value =>
        zio.aws.personalize.model.DefaultHyperParameterRanges.wrap(value)
      )
    override val defaultResourceConfig
        : Optional[Map[ParameterName, ParameterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultResourceConfig())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.personalize.model.primitives.ParameterName(
              key
            ) -> zio.aws.personalize.model.primitives.ParameterValue(value)
          })
          .toMap
      )
    override val trainingInputMode: Optional[TrainingInputMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingInputMode())
        .map(value =>
          zio.aws.personalize.model.primitives.TrainingInputMode(value)
        )
    override val roleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.Algorithm
  ): zio.aws.personalize.model.Algorithm.ReadOnly = new Wrapper(impl)
}
