package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{Arn, MetricName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AutoMLConfig(
    metricName: Optional[MetricName] = Optional.Absent,
    recipeList: Optional[Iterable[Arn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.AutoMLConfig = {
    import AutoMLConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.AutoMLConfig
      .builder()
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        recipeList.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.recipeList)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.AutoMLConfig.ReadOnly =
    zio.aws.personalize.model.AutoMLConfig.wrap(buildAwsValue())
}
object AutoMLConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.AutoMLConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.AutoMLConfig =
      zio.aws.personalize.model.AutoMLConfig(
        metricName.map(value => value),
        recipeList.map(value => value)
      )
    def metricName: Optional[MetricName]
    def recipeList: Optional[List[Arn]]
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getRecipeList: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("recipeList", recipeList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.AutoMLConfig
  ) extends zio.aws.personalize.model.AutoMLConfig.ReadOnly {
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.personalize.model.primitives.MetricName(value))
    override val recipeList: Optional[List[Arn]] = zio.aws.core.internal
      .optionalFromNullable(impl.recipeList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.primitives.Arn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.AutoMLConfig
  ): zio.aws.personalize.model.AutoMLConfig.ReadOnly = new Wrapper(impl)
}
