package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  Status,
  RoleArn,
  Date,
  FailureReason,
  Arn,
  NumBatchResults,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class BatchSegmentJob(
    jobName: Optional[Name] = Optional.Absent,
    batchSegmentJobArn: Optional[Arn] = Optional.Absent,
    filterArn: Optional[Arn] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    solutionVersionArn: Optional[Arn] = Optional.Absent,
    numResults: Optional[NumBatchResults] = Optional.Absent,
    jobInput: Optional[zio.aws.personalize.model.BatchSegmentJobInput] =
      Optional.Absent,
    jobOutput: Optional[zio.aws.personalize.model.BatchSegmentJobOutput] =
      Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.BatchSegmentJob = {
    import BatchSegmentJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.BatchSegmentJob
      .builder()
      .optionallyWith(
        jobName.map(value => Name.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(
        batchSegmentJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.batchSegmentJobArn)
      .optionallyWith(
        filterArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.filterArn)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        solutionVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionVersionArn)
      .optionallyWith(
        numResults.map(value => NumBatchResults.unwrap(value): Integer)
      )(_.numResults)
      .optionallyWith(jobInput.map(value => value.buildAwsValue()))(_.jobInput)
      .optionallyWith(jobOutput.map(value => value.buildAwsValue()))(
        _.jobOutput
      )
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.BatchSegmentJob.ReadOnly =
    zio.aws.personalize.model.BatchSegmentJob.wrap(buildAwsValue())
}
object BatchSegmentJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.BatchSegmentJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.BatchSegmentJob =
      zio.aws.personalize.model.BatchSegmentJob(
        jobName.map(value => value),
        batchSegmentJobArn.map(value => value),
        filterArn.map(value => value),
        failureReason.map(value => value),
        solutionVersionArn.map(value => value),
        numResults.map(value => value),
        jobInput.map(value => value.asEditable),
        jobOutput.map(value => value.asEditable),
        roleArn.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def jobName: Optional[Name]
    def batchSegmentJobArn: Optional[Arn]
    def filterArn: Optional[Arn]
    def failureReason: Optional[FailureReason]
    def solutionVersionArn: Optional[Arn]
    def numResults: Optional[NumBatchResults]
    def jobInput
        : Optional[zio.aws.personalize.model.BatchSegmentJobInput.ReadOnly]
    def jobOutput
        : Optional[zio.aws.personalize.model.BatchSegmentJobOutput.ReadOnly]
    def roleArn: Optional[RoleArn]
    def status: Optional[Status]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def getJobName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getBatchSegmentJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("batchSegmentJobArn", batchSegmentJobArn)
    def getFilterArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("filterArn", filterArn)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getSolutionVersionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionVersionArn", solutionVersionArn)
    def getNumResults: ZIO[Any, AwsError, NumBatchResults] =
      AwsError.unwrapOptionField("numResults", numResults)
    def getJobInput: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.BatchSegmentJobInput.ReadOnly
    ] = AwsError.unwrapOptionField("jobInput", jobInput)
    def getJobOutput: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.BatchSegmentJobOutput.ReadOnly
    ] = AwsError.unwrapOptionField("jobOutput", jobOutput)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.BatchSegmentJob
  ) extends zio.aws.personalize.model.BatchSegmentJob.ReadOnly {
    override val jobName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val batchSegmentJobArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.batchSegmentJobArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val filterArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.filterArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
    override val solutionVersionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.solutionVersionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val numResults: Optional[NumBatchResults] = zio.aws.core.internal
      .optionalFromNullable(impl.numResults())
      .map(value => zio.aws.personalize.model.primitives.NumBatchResults(value))
    override val jobInput
        : Optional[zio.aws.personalize.model.BatchSegmentJobInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobInput())
        .map(value =>
          zio.aws.personalize.model.BatchSegmentJobInput.wrap(value)
        )
    override val jobOutput
        : Optional[zio.aws.personalize.model.BatchSegmentJobOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobOutput())
        .map(value =>
          zio.aws.personalize.model.BatchSegmentJobOutput.wrap(value)
        )
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.personalize.model.primitives.RoleArn(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.BatchSegmentJob
  ): zio.aws.personalize.model.BatchSegmentJob.ReadOnly = new Wrapper(impl)
}
