package zio.aws.personalize.model
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  RoleArn,
  NumBatchResults,
  Arn,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateBatchInferenceJobRequest(
    jobName: Name,
    solutionVersionArn: Arn,
    filterArn: Optional[Arn] = Optional.Absent,
    numResults: Optional[NumBatchResults] = Optional.Absent,
    jobInput: zio.aws.personalize.model.BatchInferenceJobInput,
    jobOutput: zio.aws.personalize.model.BatchInferenceJobOutput,
    roleArn: RoleArn,
    batchInferenceJobConfig: Optional[
      zio.aws.personalize.model.BatchInferenceJobConfig
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.personalize.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobRequest = {
    import CreateBatchInferenceJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobRequest
      .builder()
      .jobName(Name.unwrap(jobName): java.lang.String)
      .solutionVersionArn(Arn.unwrap(solutionVersionArn): java.lang.String)
      .optionallyWith(
        filterArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.filterArn)
      .optionallyWith(
        numResults.map(value => NumBatchResults.unwrap(value): Integer)
      )(_.numResults)
      .jobInput(jobInput.buildAwsValue())
      .jobOutput(jobOutput.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        batchInferenceJobConfig.map(value => value.buildAwsValue())
      )(_.batchInferenceJobConfig)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateBatchInferenceJobRequest.ReadOnly =
    zio.aws.personalize.model.CreateBatchInferenceJobRequest
      .wrap(buildAwsValue())
}
object CreateBatchInferenceJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateBatchInferenceJobRequest =
      zio.aws.personalize.model.CreateBatchInferenceJobRequest(
        jobName,
        solutionVersionArn,
        filterArn.map(value => value),
        numResults.map(value => value),
        jobInput.asEditable,
        jobOutput.asEditable,
        roleArn,
        batchInferenceJobConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobName: Name
    def solutionVersionArn: Arn
    def filterArn: Optional[Arn]
    def numResults: Optional[NumBatchResults]
    def jobInput: zio.aws.personalize.model.BatchInferenceJobInput.ReadOnly
    def jobOutput: zio.aws.personalize.model.BatchInferenceJobOutput.ReadOnly
    def roleArn: RoleArn
    def batchInferenceJobConfig
        : Optional[zio.aws.personalize.model.BatchInferenceJobConfig.ReadOnly]
    def tags: Optional[List[zio.aws.personalize.model.Tag.ReadOnly]]
    def getJobName: ZIO[Any, Nothing, Name] = ZIO.succeed(jobName)
    def getSolutionVersionArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(solutionVersionArn)
    def getFilterArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("filterArn", filterArn)
    def getNumResults: ZIO[Any, AwsError, NumBatchResults] =
      AwsError.unwrapOptionField("numResults", numResults)
    def getJobInput: ZIO[
      Any,
      Nothing,
      zio.aws.personalize.model.BatchInferenceJobInput.ReadOnly
    ] = ZIO.succeed(jobInput)
    def getJobOutput: ZIO[
      Any,
      Nothing,
      zio.aws.personalize.model.BatchInferenceJobOutput.ReadOnly
    ] = ZIO.succeed(jobOutput)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getBatchInferenceJobConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.BatchInferenceJobConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "batchInferenceJobConfig",
      batchInferenceJobConfig
    )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.personalize.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobRequest
  ) extends zio.aws.personalize.model.CreateBatchInferenceJobRequest.ReadOnly {
    override val jobName: Name =
      zio.aws.personalize.model.primitives.Name(impl.jobName())
    override val solutionVersionArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.solutionVersionArn())
    override val filterArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.filterArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val numResults: Optional[NumBatchResults] = zio.aws.core.internal
      .optionalFromNullable(impl.numResults())
      .map(value => zio.aws.personalize.model.primitives.NumBatchResults(value))
    override val jobInput
        : zio.aws.personalize.model.BatchInferenceJobInput.ReadOnly =
      zio.aws.personalize.model.BatchInferenceJobInput.wrap(impl.jobInput())
    override val jobOutput
        : zio.aws.personalize.model.BatchInferenceJobOutput.ReadOnly =
      zio.aws.personalize.model.BatchInferenceJobOutput.wrap(impl.jobOutput())
    override val roleArn: RoleArn =
      zio.aws.personalize.model.primitives.RoleArn(impl.roleArn())
    override val batchInferenceJobConfig
        : Optional[zio.aws.personalize.model.BatchInferenceJobConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batchInferenceJobConfig())
        .map(value =>
          zio.aws.personalize.model.BatchInferenceJobConfig.wrap(value)
        )
    override val tags: Optional[List[zio.aws.personalize.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobRequest
  ): zio.aws.personalize.model.CreateBatchInferenceJobRequest.ReadOnly =
    new Wrapper(impl)
}
