package zio.aws.personalize.model
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{TransactionsPerSecond, Arn, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateCampaignRequest(
    name: Name,
    solutionVersionArn: Arn,
    minProvisionedTPS: Optional[TransactionsPerSecond] = Optional.Absent,
    campaignConfig: Optional[zio.aws.personalize.model.CampaignConfig] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.personalize.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateCampaignRequest = {
    import CreateCampaignRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateCampaignRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .solutionVersionArn(Arn.unwrap(solutionVersionArn): java.lang.String)
      .optionallyWith(
        minProvisionedTPS.map(value =>
          TransactionsPerSecond.unwrap(value): Integer
        )
      )(_.minProvisionedTPS)
      .optionallyWith(campaignConfig.map(value => value.buildAwsValue()))(
        _.campaignConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CreateCampaignRequest.ReadOnly =
    zio.aws.personalize.model.CreateCampaignRequest.wrap(buildAwsValue())
}
object CreateCampaignRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateCampaignRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateCampaignRequest =
      zio.aws.personalize.model.CreateCampaignRequest(
        name,
        solutionVersionArn,
        minProvisionedTPS.map(value => value),
        campaignConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Name
    def solutionVersionArn: Arn
    def minProvisionedTPS: Optional[TransactionsPerSecond]
    def campaignConfig
        : Optional[zio.aws.personalize.model.CampaignConfig.ReadOnly]
    def tags: Optional[List[zio.aws.personalize.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getSolutionVersionArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(solutionVersionArn)
    def getMinProvisionedTPS: ZIO[Any, AwsError, TransactionsPerSecond] =
      AwsError.unwrapOptionField("minProvisionedTPS", minProvisionedTPS)
    def getCampaignConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.CampaignConfig.ReadOnly
    ] = AwsError.unwrapOptionField("campaignConfig", campaignConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.personalize.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateCampaignRequest
  ) extends zio.aws.personalize.model.CreateCampaignRequest.ReadOnly {
    override val name: Name =
      zio.aws.personalize.model.primitives.Name(impl.name())
    override val solutionVersionArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.solutionVersionArn())
    override val minProvisionedTPS: Optional[TransactionsPerSecond] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minProvisionedTPS())
        .map(value =>
          zio.aws.personalize.model.primitives.TransactionsPerSecond(value)
        )
    override val campaignConfig
        : Optional[zio.aws.personalize.model.CampaignConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.campaignConfig())
        .map(value => zio.aws.personalize.model.CampaignConfig.wrap(value))
    override val tags: Optional[List[zio.aws.personalize.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateCampaignRequest
  ): zio.aws.personalize.model.CreateCampaignRequest.ReadOnly = new Wrapper(
    impl
  )
}
