package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDatasetExportJobResponse(
    datasetExportJobArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobResponse = {
    import CreateDatasetExportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobResponse
      .builder()
      .optionallyWith(
        datasetExportJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetExportJobArn)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateDatasetExportJobResponse.ReadOnly =
    zio.aws.personalize.model.CreateDatasetExportJobResponse
      .wrap(buildAwsValue())
}
object CreateDatasetExportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateDatasetExportJobResponse =
      zio.aws.personalize.model
        .CreateDatasetExportJobResponse(datasetExportJobArn.map(value => value))
    def datasetExportJobArn: Optional[Arn]
    def getDatasetExportJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetExportJobArn", datasetExportJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobResponse
  ) extends zio.aws.personalize.model.CreateDatasetExportJobResponse.ReadOnly {
    override val datasetExportJobArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetExportJobArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobResponse
  ): zio.aws.personalize.model.CreateDatasetExportJobResponse.ReadOnly =
    new Wrapper(impl)
}
