package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{RoleArn, Arn, Name}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDatasetImportJobRequest(
    jobName: Name,
    datasetArn: Arn,
    dataSource: zio.aws.personalize.model.DataSource,
    roleArn: RoleArn,
    tags: Optional[Iterable[zio.aws.personalize.model.Tag]] = Optional.Absent,
    importMode: Optional[zio.aws.personalize.model.ImportMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobRequest = {
    import CreateDatasetImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobRequest
      .builder()
      .jobName(Name.unwrap(jobName): java.lang.String)
      .datasetArn(Arn.unwrap(datasetArn): java.lang.String)
      .dataSource(dataSource.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(importMode.map(value => value.unwrap))(_.importMode)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateDatasetImportJobRequest.ReadOnly =
    zio.aws.personalize.model.CreateDatasetImportJobRequest
      .wrap(buildAwsValue())
}
object CreateDatasetImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateDatasetImportJobRequest =
      zio.aws.personalize.model.CreateDatasetImportJobRequest(
        jobName,
        datasetArn,
        dataSource.asEditable,
        roleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        importMode.map(value => value)
      )
    def jobName: Name
    def datasetArn: Arn
    def dataSource: zio.aws.personalize.model.DataSource.ReadOnly
    def roleArn: RoleArn
    def tags: Optional[List[zio.aws.personalize.model.Tag.ReadOnly]]
    def importMode: Optional[zio.aws.personalize.model.ImportMode]
    def getJobName: ZIO[Any, Nothing, Name] = ZIO.succeed(jobName)
    def getDatasetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(datasetArn)
    def getDataSource
        : ZIO[Any, Nothing, zio.aws.personalize.model.DataSource.ReadOnly] =
      ZIO.succeed(dataSource)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.personalize.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getImportMode
        : ZIO[Any, AwsError, zio.aws.personalize.model.ImportMode] =
      AwsError.unwrapOptionField("importMode", importMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobRequest
  ) extends zio.aws.personalize.model.CreateDatasetImportJobRequest.ReadOnly {
    override val jobName: Name =
      zio.aws.personalize.model.primitives.Name(impl.jobName())
    override val datasetArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetArn())
    override val dataSource: zio.aws.personalize.model.DataSource.ReadOnly =
      zio.aws.personalize.model.DataSource.wrap(impl.dataSource())
    override val roleArn: RoleArn =
      zio.aws.personalize.model.primitives.RoleArn(impl.roleArn())
    override val tags: Optional[List[zio.aws.personalize.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.Tag.wrap(item)
          }.toList
        )
    override val importMode: Optional[zio.aws.personalize.model.ImportMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importMode())
        .map(value => zio.aws.personalize.model.ImportMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobRequest
  ): zio.aws.personalize.model.CreateDatasetImportJobRequest.ReadOnly =
    new Wrapper(impl)
}
