package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{TrackingId, Arn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateEventTrackerResponse(
    eventTrackerArn: Optional[Arn] = Optional.Absent,
    trackingId: Optional[TrackingId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateEventTrackerResponse = {
    import CreateEventTrackerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateEventTrackerResponse
      .builder()
      .optionallyWith(
        eventTrackerArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventTrackerArn)
      .optionallyWith(
        trackingId.map(value => TrackingId.unwrap(value): java.lang.String)
      )(_.trackingId)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateEventTrackerResponse.ReadOnly =
    zio.aws.personalize.model.CreateEventTrackerResponse.wrap(buildAwsValue())
}
object CreateEventTrackerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateEventTrackerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateEventTrackerResponse =
      zio.aws.personalize.model.CreateEventTrackerResponse(
        eventTrackerArn.map(value => value),
        trackingId.map(value => value)
      )
    def eventTrackerArn: Optional[Arn]
    def trackingId: Optional[TrackingId]
    def getEventTrackerArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventTrackerArn", eventTrackerArn)
    def getTrackingId: ZIO[Any, AwsError, TrackingId] =
      AwsError.unwrapOptionField("trackingId", trackingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateEventTrackerResponse
  ) extends zio.aws.personalize.model.CreateEventTrackerResponse.ReadOnly {
    override val eventTrackerArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.eventTrackerArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val trackingId: Optional[TrackingId] = zio.aws.core.internal
      .optionalFromNullable(impl.trackingId())
      .map(value => zio.aws.personalize.model.primitives.TrackingId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateEventTrackerResponse
  ): zio.aws.personalize.model.CreateEventTrackerResponse.ReadOnly =
    new Wrapper(impl)
}
