package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{AvroSchema, Name}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSchemaRequest(
    name: Name,
    schema: AvroSchema,
    domain: Optional[zio.aws.personalize.model.Domain] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateSchemaRequest = {
    import CreateSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateSchemaRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .schema(AvroSchema.unwrap(schema): java.lang.String)
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CreateSchemaRequest.ReadOnly =
    zio.aws.personalize.model.CreateSchemaRequest.wrap(buildAwsValue())
}
object CreateSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateSchemaRequest =
      zio.aws.personalize.model
        .CreateSchemaRequest(name, schema, domain.map(value => value))
    def name: Name
    def schema: AvroSchema
    def domain: Optional[zio.aws.personalize.model.Domain]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getSchema: ZIO[Any, Nothing, AvroSchema] = ZIO.succeed(schema)
    def getDomain: ZIO[Any, AwsError, zio.aws.personalize.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateSchemaRequest
  ) extends zio.aws.personalize.model.CreateSchemaRequest.ReadOnly {
    override val name: Name =
      zio.aws.personalize.model.primitives.Name(impl.name())
    override val schema: AvroSchema =
      zio.aws.personalize.model.primitives.AvroSchema(impl.schema())
    override val domain: Optional[zio.aws.personalize.model.Domain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domain())
        .map(value => zio.aws.personalize.model.Domain.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateSchemaRequest
  ): zio.aws.personalize.model.CreateSchemaRequest.ReadOnly = new Wrapper(impl)
}
