package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  FailureReason,
  Arn,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DatasetExportJob(
    jobName: Optional[Name] = Optional.Absent,
    datasetExportJobArn: Optional[Arn] = Optional.Absent,
    datasetArn: Optional[Arn] = Optional.Absent,
    ingestionMode: Optional[zio.aws.personalize.model.IngestionMode] =
      Optional.Absent,
    roleArn: Optional[Arn] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    jobOutput: Optional[zio.aws.personalize.model.DatasetExportJobOutput] =
      Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DatasetExportJob = {
    import DatasetExportJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DatasetExportJob
      .builder()
      .optionallyWith(
        jobName.map(value => Name.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(
        datasetExportJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetExportJobArn)
      .optionallyWith(
        datasetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(ingestionMode.map(value => value.unwrap))(_.ingestionMode)
      .optionallyWith(
        roleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(jobOutput.map(value => value.buildAwsValue()))(
        _.jobOutput
      )
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DatasetExportJob.ReadOnly =
    zio.aws.personalize.model.DatasetExportJob.wrap(buildAwsValue())
}
object DatasetExportJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DatasetExportJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DatasetExportJob =
      zio.aws.personalize.model.DatasetExportJob(
        jobName.map(value => value),
        datasetExportJobArn.map(value => value),
        datasetArn.map(value => value),
        ingestionMode.map(value => value),
        roleArn.map(value => value),
        status.map(value => value),
        jobOutput.map(value => value.asEditable),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        failureReason.map(value => value)
      )
    def jobName: Optional[Name]
    def datasetExportJobArn: Optional[Arn]
    def datasetArn: Optional[Arn]
    def ingestionMode: Optional[zio.aws.personalize.model.IngestionMode]
    def roleArn: Optional[Arn]
    def status: Optional[Status]
    def jobOutput
        : Optional[zio.aws.personalize.model.DatasetExportJobOutput.ReadOnly]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def failureReason: Optional[FailureReason]
    def getJobName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getDatasetExportJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetExportJobArn", datasetExportJobArn)
    def getDatasetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getIngestionMode
        : ZIO[Any, AwsError, zio.aws.personalize.model.IngestionMode] =
      AwsError.unwrapOptionField("ingestionMode", ingestionMode)
    def getRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getJobOutput: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.DatasetExportJobOutput.ReadOnly
    ] = AwsError.unwrapOptionField("jobOutput", jobOutput)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DatasetExportJob
  ) extends zio.aws.personalize.model.DatasetExportJob.ReadOnly {
    override val jobName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val datasetExportJobArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetExportJobArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val datasetArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val ingestionMode
        : Optional[zio.aws.personalize.model.IngestionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ingestionMode())
        .map(value => zio.aws.personalize.model.IngestionMode.wrap(value))
    override val roleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val jobOutput
        : Optional[zio.aws.personalize.model.DatasetExportJobOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobOutput())
        .map(value =>
          zio.aws.personalize.model.DatasetExportJobOutput.wrap(value)
        )
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DatasetExportJob
  ): zio.aws.personalize.model.DatasetExportJob.ReadOnly = new Wrapper(impl)
}
