package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  FailureReason,
  Arn,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DatasetImportJobSummary(
    datasetImportJobArn: Optional[Arn] = Optional.Absent,
    jobName: Optional[Name] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    importMode: Optional[zio.aws.personalize.model.ImportMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DatasetImportJobSummary = {
    import DatasetImportJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DatasetImportJobSummary
      .builder()
      .optionallyWith(
        datasetImportJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetImportJobArn)
      .optionallyWith(
        jobName.map(value => Name.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(importMode.map(value => value.unwrap))(_.importMode)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DatasetImportJobSummary.ReadOnly =
    zio.aws.personalize.model.DatasetImportJobSummary.wrap(buildAwsValue())
}
object DatasetImportJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DatasetImportJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DatasetImportJobSummary =
      zio.aws.personalize.model.DatasetImportJobSummary(
        datasetImportJobArn.map(value => value),
        jobName.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        failureReason.map(value => value),
        importMode.map(value => value)
      )
    def datasetImportJobArn: Optional[Arn]
    def jobName: Optional[Name]
    def status: Optional[Status]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def failureReason: Optional[FailureReason]
    def importMode: Optional[zio.aws.personalize.model.ImportMode]
    def getDatasetImportJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetImportJobArn", datasetImportJobArn)
    def getJobName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getImportMode
        : ZIO[Any, AwsError, zio.aws.personalize.model.ImportMode] =
      AwsError.unwrapOptionField("importMode", importMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DatasetImportJobSummary
  ) extends zio.aws.personalize.model.DatasetImportJobSummary.ReadOnly {
    override val datasetImportJobArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetImportJobArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val jobName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
    override val importMode: Optional[zio.aws.personalize.model.ImportMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importMode())
        .map(value => zio.aws.personalize.model.ImportMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DatasetImportJobSummary
  ): zio.aws.personalize.model.DatasetImportJobSummary.ReadOnly = new Wrapper(
    impl
  )
}
