package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  Arn,
  DatasetType,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DatasetSummary(
    name: Optional[Name] = Optional.Absent,
    datasetArn: Optional[Arn] = Optional.Absent,
    datasetType: Optional[DatasetType] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DatasetSummary = {
    import DatasetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DatasetSummary
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        datasetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(
        datasetType.map(value => DatasetType.unwrap(value): java.lang.String)
      )(_.datasetType)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DatasetSummary.ReadOnly =
    zio.aws.personalize.model.DatasetSummary.wrap(buildAwsValue())
}
object DatasetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DatasetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DatasetSummary =
      zio.aws.personalize.model.DatasetSummary(
        name.map(value => value),
        datasetArn.map(value => value),
        datasetType.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def name: Optional[Name]
    def datasetArn: Optional[Arn]
    def datasetType: Optional[DatasetType]
    def status: Optional[Status]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDatasetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getDatasetType: ZIO[Any, AwsError, DatasetType] =
      AwsError.unwrapOptionField("datasetType", datasetType)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DatasetSummary
  ) extends zio.aws.personalize.model.DatasetSummary.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val datasetArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val datasetType: Optional[DatasetType] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetType())
      .map(value => zio.aws.personalize.model.primitives.DatasetType(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DatasetSummary
  ): zio.aws.personalize.model.DatasetSummary.ReadOnly = new Wrapper(impl)
}
