package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  Tunable,
  ContinuousMaxValue,
  ContinuousMinValue,
  ParameterName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DefaultContinuousHyperParameterRange(
    name: Optional[ParameterName] = Optional.Absent,
    minValue: Optional[ContinuousMinValue] = Optional.Absent,
    maxValue: Optional[ContinuousMaxValue] = Optional.Absent,
    isTunable: Optional[Tunable] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DefaultContinuousHyperParameterRange = {
    import DefaultContinuousHyperParameterRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DefaultContinuousHyperParameterRange
      .builder()
      .optionallyWith(
        name.map(value => ParameterName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        minValue.map(value =>
          ContinuousMinValue.unwrap(value): java.lang.Double
        )
      )(_.minValue)
      .optionallyWith(
        maxValue.map(value =>
          ContinuousMaxValue.unwrap(value): java.lang.Double
        )
      )(_.maxValue)
      .optionallyWith(
        isTunable.map(value => Tunable.unwrap(value): java.lang.Boolean)
      )(_.isTunable)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DefaultContinuousHyperParameterRange.ReadOnly =
    zio.aws.personalize.model.DefaultContinuousHyperParameterRange
      .wrap(buildAwsValue())
}
object DefaultContinuousHyperParameterRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DefaultContinuousHyperParameterRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.personalize.model.DefaultContinuousHyperParameterRange =
      zio.aws.personalize.model.DefaultContinuousHyperParameterRange(
        name.map(value => value),
        minValue.map(value => value),
        maxValue.map(value => value),
        isTunable.map(value => value)
      )
    def name: Optional[ParameterName]
    def minValue: Optional[ContinuousMinValue]
    def maxValue: Optional[ContinuousMaxValue]
    def isTunable: Optional[Tunable]
    def getName: ZIO[Any, AwsError, ParameterName] =
      AwsError.unwrapOptionField("name", name)
    def getMinValue: ZIO[Any, AwsError, ContinuousMinValue] =
      AwsError.unwrapOptionField("minValue", minValue)
    def getMaxValue: ZIO[Any, AwsError, ContinuousMaxValue] =
      AwsError.unwrapOptionField("maxValue", maxValue)
    def getIsTunable: ZIO[Any, AwsError, Tunable] =
      AwsError.unwrapOptionField("isTunable", isTunable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DefaultContinuousHyperParameterRange
  ) extends zio.aws.personalize.model.DefaultContinuousHyperParameterRange.ReadOnly {
    override val name: Optional[ParameterName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.ParameterName(value))
    override val minValue: Optional[ContinuousMinValue] = zio.aws.core.internal
      .optionalFromNullable(impl.minValue())
      .map(value =>
        zio.aws.personalize.model.primitives.ContinuousMinValue(value)
      )
    override val maxValue: Optional[ContinuousMaxValue] = zio.aws.core.internal
      .optionalFromNullable(impl.maxValue())
      .map(value =>
        zio.aws.personalize.model.primitives.ContinuousMaxValue(value)
      )
    override val isTunable: Optional[Tunable] = zio.aws.core.internal
      .optionalFromNullable(impl.isTunable())
      .map(value => zio.aws.personalize.model.primitives.Tunable(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DefaultContinuousHyperParameterRange
  ): zio.aws.personalize.model.DefaultContinuousHyperParameterRange.ReadOnly =
    new Wrapper(impl)
}
