package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DeleteDatasetRequest(datasetArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DeleteDatasetRequest = {
    import DeleteDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DeleteDatasetRequest
      .builder()
      .datasetArn(Arn.unwrap(datasetArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DeleteDatasetRequest.ReadOnly =
    zio.aws.personalize.model.DeleteDatasetRequest.wrap(buildAwsValue())
}
object DeleteDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DeleteDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DeleteDatasetRequest =
      zio.aws.personalize.model.DeleteDatasetRequest(datasetArn)
    def datasetArn: Arn
    def getDatasetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(datasetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DeleteDatasetRequest
  ) extends zio.aws.personalize.model.DeleteDatasetRequest.ReadOnly {
    override val datasetArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DeleteDatasetRequest
  ): zio.aws.personalize.model.DeleteDatasetRequest.ReadOnly = new Wrapper(impl)
}
