package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeBatchSegmentJobResponse(
    batchSegmentJob: Optional[zio.aws.personalize.model.BatchSegmentJob] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeBatchSegmentJobResponse = {
    import DescribeBatchSegmentJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeBatchSegmentJobResponse
      .builder()
      .optionallyWith(batchSegmentJob.map(value => value.buildAwsValue()))(
        _.batchSegmentJob
      )
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeBatchSegmentJobResponse.ReadOnly =
    zio.aws.personalize.model.DescribeBatchSegmentJobResponse
      .wrap(buildAwsValue())
}
object DescribeBatchSegmentJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeBatchSegmentJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeBatchSegmentJobResponse =
      zio.aws.personalize.model.DescribeBatchSegmentJobResponse(
        batchSegmentJob.map(value => value.asEditable)
      )
    def batchSegmentJob
        : Optional[zio.aws.personalize.model.BatchSegmentJob.ReadOnly]
    def getBatchSegmentJob: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.BatchSegmentJob.ReadOnly
    ] = AwsError.unwrapOptionField("batchSegmentJob", batchSegmentJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeBatchSegmentJobResponse
  ) extends zio.aws.personalize.model.DescribeBatchSegmentJobResponse.ReadOnly {
    override val batchSegmentJob
        : Optional[zio.aws.personalize.model.BatchSegmentJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batchSegmentJob())
        .map(value => zio.aws.personalize.model.BatchSegmentJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeBatchSegmentJobResponse
  ): zio.aws.personalize.model.DescribeBatchSegmentJobResponse.ReadOnly =
    new Wrapper(impl)
}
