package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeCampaignRequest(campaignArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeCampaignRequest = {
    import DescribeCampaignRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeCampaignRequest
      .builder()
      .campaignArn(Arn.unwrap(campaignArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DescribeCampaignRequest.ReadOnly =
    zio.aws.personalize.model.DescribeCampaignRequest.wrap(buildAwsValue())
}
object DescribeCampaignRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeCampaignRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeCampaignRequest =
      zio.aws.personalize.model.DescribeCampaignRequest(campaignArn)
    def campaignArn: Arn
    def getCampaignArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(campaignArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeCampaignRequest
  ) extends zio.aws.personalize.model.DescribeCampaignRequest.ReadOnly {
    override val campaignArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.campaignArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeCampaignRequest
  ): zio.aws.personalize.model.DescribeCampaignRequest.ReadOnly = new Wrapper(
    impl
  )
}
