package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeDatasetExportJobResponse(
    datasetExportJob: Optional[zio.aws.personalize.model.DatasetExportJob] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeDatasetExportJobResponse = {
    import DescribeDatasetExportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeDatasetExportJobResponse
      .builder()
      .optionallyWith(datasetExportJob.map(value => value.buildAwsValue()))(
        _.datasetExportJob
      )
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeDatasetExportJobResponse.ReadOnly =
    zio.aws.personalize.model.DescribeDatasetExportJobResponse
      .wrap(buildAwsValue())
}
object DescribeDatasetExportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeDatasetExportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeDatasetExportJobResponse =
      zio.aws.personalize.model.DescribeDatasetExportJobResponse(
        datasetExportJob.map(value => value.asEditable)
      )
    def datasetExportJob
        : Optional[zio.aws.personalize.model.DatasetExportJob.ReadOnly]
    def getDatasetExportJob: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.DatasetExportJob.ReadOnly
    ] = AwsError.unwrapOptionField("datasetExportJob", datasetExportJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeDatasetExportJobResponse
  ) extends zio.aws.personalize.model.DescribeDatasetExportJobResponse.ReadOnly {
    override val datasetExportJob
        : Optional[zio.aws.personalize.model.DatasetExportJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetExportJob())
        .map(value => zio.aws.personalize.model.DatasetExportJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeDatasetExportJobResponse
  ): zio.aws.personalize.model.DescribeDatasetExportJobResponse.ReadOnly =
    new Wrapper(impl)
}
