package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeDatasetResponse(
    dataset: Optional[zio.aws.personalize.model.Dataset] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeDatasetResponse = {
    import DescribeDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeDatasetResponse
      .builder()
      .optionallyWith(dataset.map(value => value.buildAwsValue()))(_.dataset)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DescribeDatasetResponse.ReadOnly =
    zio.aws.personalize.model.DescribeDatasetResponse.wrap(buildAwsValue())
}
object DescribeDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeDatasetResponse =
      zio.aws.personalize.model
        .DescribeDatasetResponse(dataset.map(value => value.asEditable))
    def dataset: Optional[zio.aws.personalize.model.Dataset.ReadOnly]
    def getDataset
        : ZIO[Any, AwsError, zio.aws.personalize.model.Dataset.ReadOnly] =
      AwsError.unwrapOptionField("dataset", dataset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeDatasetResponse
  ) extends zio.aws.personalize.model.DescribeDatasetResponse.ReadOnly {
    override val dataset: Optional[zio.aws.personalize.model.Dataset.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataset())
        .map(value => zio.aws.personalize.model.Dataset.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeDatasetResponse
  ): zio.aws.personalize.model.DescribeDatasetResponse.ReadOnly = new Wrapper(
    impl
  )
}
