package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeRecipeRequest(recipeArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeRecipeRequest = {
    import DescribeRecipeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeRecipeRequest
      .builder()
      .recipeArn(Arn.unwrap(recipeArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DescribeRecipeRequest.ReadOnly =
    zio.aws.personalize.model.DescribeRecipeRequest.wrap(buildAwsValue())
}
object DescribeRecipeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeRecipeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeRecipeRequest =
      zio.aws.personalize.model.DescribeRecipeRequest(recipeArn)
    def recipeArn: Arn
    def getRecipeArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(recipeArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeRecipeRequest
  ) extends zio.aws.personalize.model.DescribeRecipeRequest.ReadOnly {
    override val recipeArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.recipeArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeRecipeRequest
  ): zio.aws.personalize.model.DescribeRecipeRequest.ReadOnly = new Wrapper(
    impl
  )
}
