package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeRecommenderRequest(recommenderArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeRecommenderRequest = {
    import DescribeRecommenderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeRecommenderRequest
      .builder()
      .recommenderArn(Arn.unwrap(recommenderArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeRecommenderRequest.ReadOnly =
    zio.aws.personalize.model.DescribeRecommenderRequest.wrap(buildAwsValue())
}
object DescribeRecommenderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeRecommenderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeRecommenderRequest =
      zio.aws.personalize.model.DescribeRecommenderRequest(recommenderArn)
    def recommenderArn: Arn
    def getRecommenderArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(recommenderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeRecommenderRequest
  ) extends zio.aws.personalize.model.DescribeRecommenderRequest.ReadOnly {
    override val recommenderArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.recommenderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeRecommenderRequest
  ): zio.aws.personalize.model.DescribeRecommenderRequest.ReadOnly =
    new Wrapper(impl)
}
