package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeRecommenderResponse(
    recommender: Optional[zio.aws.personalize.model.Recommender] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeRecommenderResponse = {
    import DescribeRecommenderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeRecommenderResponse
      .builder()
      .optionallyWith(recommender.map(value => value.buildAwsValue()))(
        _.recommender
      )
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeRecommenderResponse.ReadOnly =
    zio.aws.personalize.model.DescribeRecommenderResponse.wrap(buildAwsValue())
}
object DescribeRecommenderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeRecommenderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeRecommenderResponse =
      zio.aws.personalize.model
        .DescribeRecommenderResponse(recommender.map(value => value.asEditable))
    def recommender: Optional[zio.aws.personalize.model.Recommender.ReadOnly]
    def getRecommender
        : ZIO[Any, AwsError, zio.aws.personalize.model.Recommender.ReadOnly] =
      AwsError.unwrapOptionField("recommender", recommender)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeRecommenderResponse
  ) extends zio.aws.personalize.model.DescribeRecommenderResponse.ReadOnly {
    override val recommender
        : Optional[zio.aws.personalize.model.Recommender.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommender())
        .map(value => zio.aws.personalize.model.Recommender.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeRecommenderResponse
  ): zio.aws.personalize.model.DescribeRecommenderResponse.ReadOnly =
    new Wrapper(impl)
}
